/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl.pool;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.asyncsql.impl.ScalaUtils;
import io.vertx.ext.asyncsql.impl.VertxEventLoopExecutionContext;
import java.util.ArrayDeque;
import java.util.Deque;

public abstract class AsyncConnectionPool {
    private final int maxPoolSize;
    private static final Logger logger = LoggerFactory.getLogger(AsyncConnectionPool.class);
    protected final Configuration configuration;
    protected final Vertx vertx;
    private int poolSize = 0;
    private final Deque<Connection> availableConnections = new ArrayDeque<Connection>();
    private final Deque<Handler<AsyncResult<Connection>>> waiters = new ArrayDeque<Handler<AsyncResult<Connection>>>();

    public AsyncConnectionPool(Vertx vertx, int maxPoolSize, Configuration configuration) {
        this.vertx = vertx;
        this.maxPoolSize = maxPoolSize;
        this.configuration = configuration;
    }

    protected abstract Connection create();

    private synchronized void createConnection(Handler<AsyncResult<Connection>> handler) {
        ++this.poolSize;
        try {
            Connection connection = this.create();
            connection.connect().onComplete(ScalaUtils.toFunction1(asyncResult -> {
                if (asyncResult.failed()) {
                    --this.poolSize;
                    this.notifyWaitersAboutAvailableConnection();
                }
                handler.handle(asyncResult);
            }), VertxEventLoopExecutionContext.create(this.vertx));
        }
        catch (Throwable e) {
            logger.info((Object)"creating a connection went wrong", e);
            --this.poolSize;
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private synchronized void waitForAvailableConnection(Handler<AsyncResult<Connection>> handler) {
        this.waiters.add(handler);
    }

    private synchronized void createOrWaitForAvailableConnection(Handler<AsyncResult<Connection>> handler) {
        if (this.poolSize < this.maxPoolSize) {
            this.createConnection(handler);
        } else {
            this.waitForAvailableConnection(handler);
        }
    }

    public synchronized void take(Handler<AsyncResult<Connection>> handler) {
        Connection connection = this.availableConnections.poll();
        if (connection == null) {
            this.createOrWaitForAvailableConnection(handler);
        } else if (connection.isConnected()) {
            handler.handle((Object)Future.succeededFuture((Object)connection));
        } else {
            --this.poolSize;
            this.take(handler);
        }
    }

    private synchronized void notifyWaitersAboutAvailableConnection() {
        Handler<AsyncResult<Connection>> handler = this.waiters.poll();
        if (handler != null) {
            this.take(handler);
        }
    }

    public synchronized void giveBack(Connection connection) {
        if (connection.isConnected()) {
            this.availableConnections.add(connection);
        } else {
            --this.poolSize;
        }
        this.notifyWaitersAboutAvailableConnection();
    }

    public synchronized void close() {
        this.availableConnections.forEach(Connection::disconnect);
    }

    public synchronized void close(Handler<AsyncResult<Void>> handler) {
        this.close();
        if (handler != null) {
            handler.handle((Object)Future.succeededFuture());
        }
    }
}

