/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Objects;
import scala.concurrent.ExecutionContext;

public class VertxEventLoopExecutionContext
implements ExecutionContext {
    private final Context context;

    public static ExecutionContext create(Vertx vertx) {
        return new VertxEventLoopExecutionContext(vertx);
    }

    private VertxEventLoopExecutionContext(Vertx vertx) {
        Objects.requireNonNull(vertx);
        Context ctx = Vertx.currentContext();
        if (ctx == null) {
            ctx = vertx.getOrCreateContext();
        }
        this.context = ctx;
    }

    public void execute(Runnable runnable) {
        if (this.context == Vertx.currentContext()) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this.reportFailure(e);
            }
        } else {
            this.context.runOnContext(v -> {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    this.reportFailure(e);
                }
            });
        }
    }

    public void reportFailure(Throwable cause) {
        Handler exceptionHandler = this.context.exceptionHandler();
        if (exceptionHandler != null) {
            exceptionHandler.handle((Object)cause);
        }
    }

    public ExecutionContext prepare() {
        return this;
    }
}

