/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.contract.OpenAPIContractException;

public class MediaTypeImpl
implements MediaType {
    private static final String KEY_SCHEMA = "schema";
    private final JsonObject mediaTypeModel;
    private final JsonSchema schema;

    public MediaTypeImpl(JsonObject mediaTypeModel) {
        this.mediaTypeModel = mediaTypeModel;
        JsonObject schemaJson = mediaTypeModel.getJsonObject(KEY_SCHEMA);
        if (schemaJson == null || schemaJson.isEmpty()) {
            throw OpenAPIContractException.createUnsupportedFeature("Media Type without a schema");
        }
        this.schema = JsonSchema.of((JsonObject)schemaJson);
    }

    @Override
    public JsonSchema getSchema() {
        return this.schema;
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.mediaTypeModel.copy();
    }
}

