/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.json.schema.JsonSchemaValidationException;
import io.vertx.json.schema.OutputUnit;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.contract.Response;
import io.vertx.openapi.validation.ResponseParameter;
import io.vertx.openapi.validation.ResponseValidator;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatedResponse;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.impl.BaseValidator;
import io.vertx.openapi.validation.impl.RequestParameterImpl;
import io.vertx.openapi.validation.impl.ValidatedResponseImpl;
import io.vertx.openapi.validation.transformer.BodyTransformer;
import io.vertx.openapi.validation.transformer.ParameterTransformer;
import io.vertx.openapi.validation.transformer.SimpleTransformer;
import java.util.HashMap;
import java.util.Optional;

public class ResponseValidatorImpl
extends BaseValidator
implements ResponseValidator {
    private static final ParameterTransformer TRANSFORMER = new SimpleTransformer();

    public ResponseValidatorImpl(Vertx vertx, OpenAPIContract contract) {
        super(vertx, contract);
    }

    Future<Response> getResponse(ValidatableResponse params, String operationId) {
        return this.getOperation(operationId).compose(op -> {
            Response response = Optional.ofNullable(op.getResponse(params.getStatusCode())).orElse(op.getDefaultResponse());
            if (response == null) {
                return Future.failedFuture((Throwable)ValidatorException.createResponseNotFound(params.getStatusCode(), operationId));
            }
            return Future.succeededFuture((Object)response);
        });
    }

    @Override
    public Future<ValidatedResponse> validate(ValidatableResponse params, String operationId) {
        return this.getResponse(params, operationId).compose(response -> this.vertx.executeBlocking(p -> {
            HashMap<String, ResponseParameter> headers = new HashMap<String, ResponseParameter>(params.getHeaders().size());
            for (Parameter header : response.getHeaders()) {
                headers.put(header.getName(), this.validateParameter(header, params.getHeaders().get(header.getName())));
            }
            ResponseParameter body = this.validateBody((Response)response, params);
            p.complete((Object)new ValidatedResponseImpl(headers, body, params));
        }));
    }

    ResponseParameter validateParameter(Parameter parameter, ResponseParameter value) throws ValidatorException {
        if (value == null || value.isNull()) {
            if (parameter.isRequired()) {
                throw ValidatorException.createMissingRequiredParameter(parameter);
            }
            return new RequestParameterImpl(null);
        }
        Object transformedValue = TRANSFORMER.transform(parameter, value.getString());
        OutputUnit result = this.contract.getSchemaRepository().validator(parameter.getSchema()).validate(transformedValue);
        try {
            result.checkValidity();
            return new RequestParameterImpl(transformedValue);
        }
        catch (JsonSchemaValidationException e) {
            throw ValidatorException.createInvalidValue(parameter, e);
        }
    }

    ResponseParameter validateBody(Response response, ValidatableResponse params) {
        if (response.getContent().isEmpty()) {
            return new RequestParameterImpl(null);
        }
        if (params.getBody() == null || params.getBody().isEmpty()) {
            throw new ValidatorException("The related response does not contain the required body.", ValidatorErrorType.MISSING_REQUIRED_PARAMETER);
        }
        String mediaTypeIdentifier = params.getContentType();
        MediaType mediaType = response.getContent().get(mediaTypeIdentifier);
        BodyTransformer transformer = (BodyTransformer)this.bodyTransformers.get(mediaTypeIdentifier);
        if (transformer == null || mediaType == null) {
            throw new ValidatorException("The format of the response body is not supported", ValidatorErrorType.UNSUPPORTED_VALUE_FORMAT);
        }
        Object transformedValue = transformer.transform(mediaType, params.getBody().getBuffer());
        OutputUnit result = this.contract.getSchemaRepository().validator(mediaType.getSchema()).validate(transformedValue);
        try {
            result.checkValidity();
            return new RequestParameterImpl(transformedValue);
        }
        catch (JsonSchemaValidationException e) {
            throw ValidatorException.createInvalidValueBody(e);
        }
    }
}

