/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.openapi.validation.ResponseParameter;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatedResponse;
import io.vertx.openapi.validation.impl.RequestParameterImpl;
import java.util.Collections;
import java.util.Map;

public class ValidatedResponseImpl
implements ValidatedResponse {
    private final Map<String, ResponseParameter> headers;
    private final ResponseParameter body;
    private final ValidatableResponse unvalidated;

    public ValidatedResponseImpl(Map<String, ResponseParameter> headers, ResponseParameter body, ValidatableResponse unvalidated) {
        this.headers = ValidatedResponseImpl.safeUnmodifiableMap(headers);
        this.body = body == null ? new RequestParameterImpl(null) : body;
        this.unvalidated = unvalidated;
    }

    protected static Map<String, ResponseParameter> safeUnmodifiableMap(Map<String, ResponseParameter> map) {
        return Collections.unmodifiableMap(map == null ? Collections.emptyMap() : map);
    }

    @Override
    public Map<String, ResponseParameter> getHeaders() {
        return this.headers;
    }

    @Override
    public ResponseParameter getBody() {
        return this.body;
    }

    @Override
    public Future<Void> send(HttpServerResponse serverResponse) {
        serverResponse.setStatusCode(this.unvalidated.getStatusCode());
        for (String header : this.headers.keySet()) {
            ResponseParameter headerValue = this.unvalidated.getHeaders().get(header);
            if (headerValue == null) continue;
            serverResponse.headers().add(header, headerValue.getString());
        }
        if (this.body.isEmpty()) {
            return serverResponse.send();
        }
        serverResponse.headers().add(HttpHeaders.CONTENT_TYPE.toString(), this.unvalidated.getContentType());
        return serverResponse.send(this.unvalidated.getBody().getBuffer());
    }
}

