/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.OutputFormat;
import io.vertx.json.schema.OutputUnit;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.openapi.contract.OpenAPIContractException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum OpenAPIVersion {
    V3_0("3.0.", Draft.DRAFT4, "https://spec.openapis.org/oas/3.0/schema/2021-09-28", new String[0]),
    V3_1("3.1.", Draft.DRAFT202012, "https://spec.openapis.org/oas/3.1/schema/2022-10-07", "https://spec.openapis.org/oas/3.1/dialect/base", "https://spec.openapis.org/oas/3.1/meta/base", "https://spec.openapis.org/oas/3.1/schema-base/2022-10-07");

    final List<String> schemaFiles;
    private final String schemaVersion;
    private final Draft draft;
    private final String mainSchemaFile;

    private OpenAPIVersion(String schemaVersion, Draft draft, String mainSchemaFile, String ... additionalSchemaFiles) {
        this.schemaVersion = schemaVersion;
        this.draft = draft;
        this.mainSchemaFile = mainSchemaFile;
        this.schemaFiles = new ArrayList<String>(Arrays.asList(additionalSchemaFiles));
        this.schemaFiles.add(mainSchemaFile);
    }

    public static OpenAPIVersion fromContract(JsonObject contract) {
        String version = Optional.ofNullable(contract).map(spec -> spec.getString("openapi")).orElseThrow(() -> OpenAPIContractException.createInvalidContract("Field \"openapi\" is missing"));
        if (version.startsWith(OpenAPIVersion.V3_0.schemaVersion)) {
            return V3_0;
        }
        if (version.startsWith(OpenAPIVersion.V3_1.schemaVersion)) {
            return V3_1;
        }
        throw OpenAPIContractException.createUnsupportedVersion(version);
    }

    public Future<OutputUnit> validate(Vertx vertx, SchemaRepository repo, JsonObject contract) {
        return vertx.executeBlocking(p -> p.complete((Object)repo.validator(this.mainSchemaFile).validate((Object)contract)));
    }

    public Future<JsonObject> resolve(Vertx vertx, SchemaRepository repo, JsonObject contract) {
        return vertx.executeBlocking(p -> {
            JsonSchema schema = JsonSchema.of((JsonObject)contract);
            repo.dereference(schema);
            JsonObject resolved = repo.resolve(contract);
            p.complete((Object)resolved);
        });
    }

    public Future<SchemaRepository> getRepository(Vertx vertx, String baseUri) {
        JsonSchemaOptions opts = new JsonSchemaOptions().setDraft(this.draft).setBaseUri(baseUri).setOutputFormat(OutputFormat.Basic);
        return vertx.executeBlocking(p -> {
            SchemaRepository repo = SchemaRepository.create((JsonSchemaOptions)opts).preloadMetaSchema(vertx.fileSystem());
            for (String ref : this.schemaFiles) {
                JsonObject raw = new JsonObject(vertx.fileSystem().readFileBlocking(ref.substring("https://".length())));
                repo.dereference(ref, JsonSchema.of((JsonObject)raw));
            }
            p.complete((Object)repo);
        });
    }
}

