/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.OpenAPIVersion;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Path;
import io.vertx.openapi.contract.SecurityRequirement;
import io.vertx.openapi.contract.SecurityScheme;
import io.vertx.openapi.contract.Server;
import io.vertx.openapi.contract.impl.PathFinder;
import io.vertx.openapi.contract.impl.PathImpl;
import io.vertx.openapi.contract.impl.SecurityRequirementImpl;
import io.vertx.openapi.contract.impl.SecuritySchemeImpl;
import io.vertx.openapi.contract.impl.ServerImpl;
import io.vertx.openapi.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class OpenAPIContractImpl
implements OpenAPIContract {
    private static final String KEY_SERVERS = "servers";
    private static final String KEY_PATHS = "paths";
    private static final String KEY_SECURITY = "security";
    private static final String PATH_PARAM_PLACEHOLDER_REGEX = "\\{(.*?)}";
    private static final UnaryOperator<String> ELIMINATE_PATH_PARAM_PLACEHOLDER = path -> path.replaceAll(PATH_PARAM_PLACEHOLDER_REGEX, "{}");
    private final List<Server> servers;
    private final List<Path> paths;
    private final Map<String, Operation> operations;
    private final OpenAPIVersion version;
    private final JsonObject rawContract;
    private final SchemaRepository schemaRepository;
    private final PathFinder pathFinder;
    private final List<SecurityRequirement> securityRequirements;
    private final Map<String, SecurityScheme> securitySchemes;
    final String basePath;

    public OpenAPIContractImpl(JsonObject resolvedSpec, OpenAPIVersion version, SchemaRepository schemaRepository) {
        this.rawContract = resolvedSpec;
        this.version = version;
        this.schemaRepository = schemaRepository;
        this.servers = Collections.unmodifiableList(resolvedSpec.getJsonArray(KEY_SERVERS, Utils.EMPTY_JSON_ARRAY).stream().map(JsonObject.class::cast).map(ServerImpl::new).collect(Collectors.toList()));
        this.securityRequirements = Collections.unmodifiableList(resolvedSpec.getJsonArray(KEY_SECURITY, Utils.EMPTY_JSON_ARRAY).stream().map(JsonObject.class::cast).map(SecurityRequirementImpl::new).collect(Collectors.toList()));
        if (this.servers.stream().collect(Collectors.groupingBy(Server::getBasePath)).size() > 1) {
            throw OpenAPIContractException.createUnsupportedFeature("Different base paths in server urls");
        }
        this.basePath = this.servers.isEmpty() ? "" : this.servers.get(0).getBasePath();
        List<PathImpl> unsortedPaths = resolvedSpec.getJsonObject(KEY_PATHS, Utils.EMPTY_JSON_OBJECT).stream().filter(JsonSchema.EXCLUDE_ANNOTATION_ENTRIES).map(pathEntry -> new PathImpl(this.basePath, (String)pathEntry.getKey(), (JsonObject)pathEntry.getValue(), this.securityRequirements)).collect(Collectors.toList());
        List<PathImpl> sortedPaths = OpenAPIContractImpl.applyMountOrder(unsortedPaths);
        this.paths = Collections.unmodifiableList(sortedPaths);
        this.operations = this.paths.stream().flatMap(path -> path.getOperations().stream()).collect(Collectors.toMap(Operation::getOperationId, operation -> operation));
        this.pathFinder = new PathFinder(sortedPaths);
        this.securitySchemes = resolvedSpec.getJsonObject("components", Utils.EMPTY_JSON_OBJECT).getJsonObject("securitySchemes", Utils.EMPTY_JSON_OBJECT).stream().filter(JsonSchema.EXCLUDE_ANNOTATION_ENTRIES).collect(Collectors.toMap(Map.Entry::getKey, value -> new SecuritySchemeImpl((JsonObject)value.getValue())));
    }

    static List<PathImpl> applyMountOrder(List<PathImpl> unsorted) {
        if (unsorted.size() <= 1) {
            return unsorted;
        }
        ArrayList<PathImpl> withTemplating = new ArrayList<PathImpl>();
        ArrayList<PathImpl> withoutTemplating = new ArrayList<PathImpl>();
        for (PathImpl path : unsorted) {
            if (path.getName().contains("{")) {
                withTemplating.add(path);
                continue;
            }
            withoutTemplating.add(path);
        }
        withTemplating.sort(Comparator.comparing(p -> (String)ELIMINATE_PATH_PARAM_PLACEHOLDER.apply(p.getName())));
        withoutTemplating.sort(Comparator.comparing(p -> (String)ELIMINATE_PATH_PARAM_PLACEHOLDER.apply(p.getName())));
        for (int x = 1; x < withTemplating.size(); ++x) {
            String second;
            String secondWithoutPlaceholder;
            String first = ((PathImpl)withTemplating.get(x - 1)).getName();
            String firstWithoutPlaceHolder = (String)ELIMINATE_PATH_PARAM_PLACEHOLDER.apply(first);
            if (!firstWithoutPlaceHolder.equals(secondWithoutPlaceholder = (String)ELIMINATE_PATH_PARAM_PLACEHOLDER.apply(second = ((PathImpl)withTemplating.get(x)).getName()))) continue;
            if (first.equals(second)) {
                throw OpenAPIContractException.createInvalidContract("Found Path duplicate: " + first);
            }
            throw OpenAPIContractException.createInvalidContract("Found Paths with same hierarchy but different templated names: " + firstWithoutPlaceHolder);
        }
        withoutTemplating.addAll(withTemplating);
        return withoutTemplating;
    }

    @Override
    public @Nullable Operation operation(String operationId) {
        return this.operations.get(operationId);
    }

    @Override
    public List<Operation> operations() {
        return Collections.unmodifiableList(new ArrayList<Operation>(this.operations.values()));
    }

    @Override
    public List<Path> getPaths() {
        return this.paths;
    }

    @Override
    public JsonObject getRawContract() {
        return this.rawContract;
    }

    @Override
    public OpenAPIVersion getVersion() {
        return this.version;
    }

    @Override
    public SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }

    @Override
    public Path findPath(String urlPath) {
        return this.pathFinder.findPath(urlPath);
    }

    @Override
    public Operation findOperation(String urlPath, HttpMethod method) {
        Path pathObject = this.findPath(urlPath);
        if (pathObject != null) {
            for (Operation op : pathObject.getOperations()) {
                if (!op.getHttpMethod().equals((Object)method)) continue;
                return op;
            }
        }
        return null;
    }

    @Override
    public List<SecurityRequirement> getSecurityRequirements() {
        return this.securityRequirements;
    }

    @Override
    public SecurityScheme securityScheme(String name) {
        return this.securitySchemes.get(name);
    }
}

