/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

interface Parameter {
    default public @Nullable String getString() {
        return this.isString() ? (String)this.get() : null;
    }

    default public boolean isString() {
        return !this.isNull() && this.get() instanceof String;
    }

    default public @Nullable Integer getInteger() {
        return this.isNumber() ? Integer.valueOf(((Number)this.get()).intValue()) : null;
    }

    default public @Nullable Long getLong() {
        return this.isNumber() ? Long.valueOf(((Number)this.get()).longValue()) : null;
    }

    default public @Nullable Float getFloat() {
        return this.isNumber() ? Float.valueOf(((Number)this.get()).floatValue()) : null;
    }

    default public @Nullable Double getDouble() {
        return this.isNumber() ? Double.valueOf(((Number)this.get()).doubleValue()) : null;
    }

    default public boolean isNumber() {
        return !this.isNull() && this.get() instanceof Number;
    }

    default public @Nullable Boolean getBoolean() {
        return this.isBoolean() ? (Boolean)this.get() : null;
    }

    default public boolean isBoolean() {
        return !this.isNull() && this.get() instanceof Boolean;
    }

    default public @Nullable JsonObject getJsonObject() {
        return this.isJsonObject() ? (JsonObject)this.get() : null;
    }

    default public boolean isJsonObject() {
        return !this.isNull() && this.get() instanceof JsonObject;
    }

    default public @Nullable JsonArray getJsonArray() {
        return this.isJsonArray() ? (JsonArray)this.get() : null;
    }

    default public boolean isJsonArray() {
        return !this.isNull() && this.get() instanceof JsonArray;
    }

    default public @Nullable Buffer getBuffer() {
        return this.isBuffer() ? (Buffer)this.get() : null;
    }

    default public boolean isBuffer() {
        return !this.isNull() && this.get() instanceof Buffer;
    }

    default public boolean isNull() {
        return this.get() == null;
    }

    default public boolean isEmpty() {
        return this.isNull() || this.isString() && this.getString().isEmpty() || this.isJsonObject() && this.getJsonObject().isEmpty() || this.isJsonArray() && this.getJsonArray().isEmpty() || this.isBuffer() && this.getBuffer().length() == 0;
    }

    @CacheReturn
    public Object get();
}

