/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.json.schema.JsonSchema;
import io.vertx.openapi.contract.OpenAPIObject;
import java.util.Arrays;
import java.util.List;

@VertxGen
public interface MediaType
extends OpenAPIObject {
    public static final String APPLICATION_JSON = HttpHeaderValues.APPLICATION_JSON.toString();
    public static final String APPLICATION_JSON_UTF8 = APPLICATION_JSON + "; charset=utf-8";
    public static final List<String> SUPPORTED_MEDIA_TYPES = Arrays.asList(APPLICATION_JSON, APPLICATION_JSON_UTF8);

    public static boolean isMediaTypeSupported(String type) {
        return SUPPORTED_MEDIA_TYPES.contains(type.toLowerCase());
    }

    public JsonSchema getSchema();

    public String getIdentifier();
}

