/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract;

import io.vertx.openapi.contract.ContractErrorType;
import io.vertx.openapi.contract.Location;

public class OpenAPIContractException
extends RuntimeException {
    private final ContractErrorType type;

    public OpenAPIContractException(String message, ContractErrorType type, Throwable cause) {
        super(message, cause);
        this.type = type;
    }

    public static OpenAPIContractException createInvalidContract(String reason) {
        return OpenAPIContractException.createInvalidContract(reason, null);
    }

    public static OpenAPIContractException createInvalidContract(String reason, Throwable cause) {
        String msg = "The passed OpenAPI contract is invalid" + (reason == null ? "." : ": " + reason);
        return new OpenAPIContractException(msg, ContractErrorType.INVALID_SPEC, cause);
    }

    public static OpenAPIContractException createUnsupportedVersion(String version) {
        return new OpenAPIContractException("The version of the passed OpenAPI contract is not supported: " + version, ContractErrorType.UNSUPPORTED_SPEC, null);
    }

    public static OpenAPIContractException createUnsupportedFeature(String feature) {
        return new OpenAPIContractException("The passed OpenAPI contract contains a feature that is not supported: " + feature, ContractErrorType.UNSUPPORTED_FEATURE, null);
    }

    public static OpenAPIContractException createInvalidStyle(Location in, String allowedStyles) {
        String reason = String.format("The style of a %s parameter MUST be %s", new Object[]{in, allowedStyles});
        return OpenAPIContractException.createInvalidContract(reason);
    }

    public ContractErrorType type() {
        return this.type;
    }
}

