/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.netty.util.internal.StringUtil;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.common.dsl.SchemaType;
import io.vertx.openapi.contract.Location;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.contract.Style;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParameterImpl
implements Parameter {
    private static final String KEY_NAME = "name";
    private static final String KEY_IN = "in";
    private static final String KEY_REQUIRED = "required";
    private static final String KEY_STYLE = "style";
    private static final String KEY_EXPLODE = "explode";
    private static final String KEY_SCHEMA = "schema";
    private static final String KEY_CONTENT = "content";
    private final String name;
    private final Location in;
    private final boolean required;
    private final boolean explode;
    private final JsonObject parameterModel;
    private final JsonSchema schema;
    private final SchemaType schemaType;
    private final Style style;

    public ParameterImpl(String path, JsonObject parameterModel) {
        this.name = parameterModel.getString(KEY_NAME);
        this.required = Optional.ofNullable(parameterModel.getBoolean(KEY_REQUIRED)).orElse(false);
        this.in = Location.parse(parameterModel.getString(KEY_IN));
        this.style = Optional.ofNullable(Style.parse(parameterModel.getString(KEY_STYLE))).orElse(Style.defaultByLocation(this.in));
        this.explode = Optional.ofNullable(parameterModel.getBoolean(KEY_EXPLODE)).orElse(this.style == Style.FORM);
        this.parameterModel = parameterModel;
        JsonObject schemaJson = parameterModel.getJsonObject(KEY_SCHEMA);
        if (schemaJson == null) {
            if (parameterModel.containsKey(KEY_CONTENT)) {
                throw OpenAPIContractException.createUnsupportedFeature("Usage of property \"content\" in parameter definition");
            }
            throw OpenAPIContractException.createInvalidContract("A parameter MUST contain either the \"schema\" or \"content\" property");
        }
        this.schema = JsonSchema.of((JsonObject)schemaJson);
        String schemaTypeString = (String)this.schema.get("type");
        if (schemaTypeString == null) {
            throw OpenAPIContractException.createInvalidContract("Missing \"type\" for \"schema\" property in parameter: " + this.name);
        }
        this.schemaType = SchemaType.valueOf((String)schemaTypeString.toUpperCase());
        if (this.in == Location.PATH) {
            if (StringUtil.isNullOrEmpty((String)this.name) || !path.contains("{" + this.name + "}")) {
                throw OpenAPIContractException.createInvalidContract("Path parameters MUST have a name that is part of the path");
            }
            if (!this.required) {
                throw OpenAPIContractException.createInvalidContract("\"required\" MUST be true for path parameters");
            }
            if (this.style != Style.SIMPLE && this.style != Style.LABEL && this.style != Style.MATRIX) {
                throw OpenAPIContractException.createInvalidStyle(this.in, "simple, label or matrix");
            }
        } else if (this.in == Location.COOKIE) {
            if (this.style != Style.FORM) {
                throw OpenAPIContractException.createInvalidStyle(this.in, "form");
            }
            if (this.schemaType == SchemaType.ARRAY && this.explode) {
                throw OpenAPIContractException.createUnsupportedFeature("Cookie parameter values formatted as exploded array");
            }
        } else if (this.in == Location.HEADER) {
            if (this.style != Style.SIMPLE) {
                throw OpenAPIContractException.createInvalidStyle(this.in, "simple");
            }
        } else if (this.in == Location.QUERY) {
            if (this.style != Style.FORM && this.style != Style.SPACE_DELIMITED && this.style != Style.PIPE_DELIMITED && this.style != Style.DEEP_OBJECT) {
                throw OpenAPIContractException.createInvalidStyle(this.in, "form, spaceDelimited, pipeDelimited or deepObject");
            }
            if (this.style == Style.SPACE_DELIMITED || this.style == Style.PIPE_DELIMITED || this.style == Style.DEEP_OBJECT) {
                throw OpenAPIContractException.createUnsupportedFeature("Parameters of style: " + (Object)((Object)this.style));
            }
        }
    }

    public static List<Parameter> parseParameters(String path, JsonArray parametersArray) {
        return parametersArray.stream().map(JsonObject.class::cast).map(parameterModel -> new ParameterImpl(path, (JsonObject)parameterModel)).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Location getIn() {
        return this.in;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public boolean isExplode() {
        return this.explode;
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.parameterModel;
    }

    @Override
    public JsonSchema getSchema() {
        return this.schema;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }
}

