/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.contract.Path;
import io.vertx.openapi.contract.SecurityRequirement;
import io.vertx.openapi.contract.impl.OperationImpl;
import io.vertx.openapi.contract.impl.ParameterImpl;
import io.vertx.openapi.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class PathImpl
implements Path {
    static final Pattern INVALID_CURLY_BRACES = Pattern.compile("/[^/]+\\{|}[^/]+/|}[^/]+$");
    private static final String KEY_PARAMETERS = "parameters";
    private static final Map<String, HttpMethod> SUPPORTED_METHODS = new HashMap<String, HttpMethod>(8);
    private final String name;
    private final List<Operation> operations;
    private final List<Parameter> parameters;
    private final JsonObject pathModel;
    private final String absolutePath;

    public PathImpl(String basePath, String name, JsonObject pathModel, List<SecurityRequirement> globalSecReq) {
        this.absolutePath = (basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath) + name;
        this.pathModel = pathModel;
        if (name.contains("*")) {
            throw OpenAPIContractException.createInvalidContract("Paths must not have a wildcard (asterisk): " + name);
        }
        if (INVALID_CURLY_BRACES.matcher(name).find()) {
            throw OpenAPIContractException.createInvalidContract("Curly brace MUST be the first/last character in a path segment (/{parameterName}/): " + name);
        }
        this.name = name.length() > 1 && name.endsWith("/") ? name.substring(0, name.length() - 1) : name;
        this.parameters = Collections.unmodifiableList(ParameterImpl.parseParameters(name, pathModel.getJsonArray(KEY_PARAMETERS, Utils.EMPTY_JSON_ARRAY)));
        ArrayList ops = new ArrayList();
        SUPPORTED_METHODS.forEach((methodName, method) -> Optional.ofNullable(pathModel.getJsonObject(methodName)).map(operationModel -> new OperationImpl(this.absolutePath, name, (HttpMethod)method, (JsonObject)operationModel, this.parameters, globalSecReq)).ifPresent(ops::add));
        this.operations = Collections.unmodifiableList(ops);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.pathModel;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    static {
        SUPPORTED_METHODS.put("get", HttpMethod.GET);
        SUPPORTED_METHODS.put("put", HttpMethod.PUT);
        SUPPORTED_METHODS.put("post", HttpMethod.POST);
        SUPPORTED_METHODS.put("delete", HttpMethod.DELETE);
        SUPPORTED_METHODS.put("options", HttpMethod.OPTIONS);
        SUPPORTED_METHODS.put("head", HttpMethod.HEAD);
        SUPPORTED_METHODS.put("patch", HttpMethod.PATCH);
        SUPPORTED_METHODS.put("trace", HttpMethod.TRACE);
    }
}

