/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.impl;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.transformer.ApplicationJsonTransformer;
import io.vertx.openapi.validation.transformer.BodyTransformer;
import java.util.HashMap;
import java.util.Map;

class BaseValidator {
    protected final Vertx vertx;
    protected final OpenAPIContract contract;
    protected final Map<String, BodyTransformer> bodyTransformers;

    public BaseValidator(Vertx vertx, OpenAPIContract contract) {
        this.vertx = vertx;
        this.contract = contract;
        this.bodyTransformers = new HashMap<String, BodyTransformer>();
        this.bodyTransformers.put(HttpHeaderValues.APPLICATION_JSON.toString(), new ApplicationJsonTransformer());
    }

    Future<Operation> getOperation(String operationId) {
        Operation operation = this.contract.operation(operationId);
        if (operation == null) {
            return Future.failedFuture((Throwable)ValidatorException.createOperationIdInvalid(operationId));
        }
        return Future.succeededFuture((Object)operation);
    }
}

