/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.transformer.ApplicationJsonTransformer;
import io.vertx.openapi.validation.transformer.BodyTransformer;
import io.vertx.openapi.validation.transformer.MultipartFormTransformer;
import java.util.HashMap;
import java.util.Map;

class BaseValidator {
    protected final Vertx vertx;
    protected final OpenAPIContract contract;
    protected final Map<String, BodyTransformer> bodyTransformers;

    public BaseValidator(Vertx vertx, OpenAPIContract contract) {
        this.vertx = vertx;
        this.contract = contract;
        this.bodyTransformers = new HashMap<String, BodyTransformer>();
        this.bodyTransformers.put(MediaType.APPLICATION_JSON, new ApplicationJsonTransformer());
        this.bodyTransformers.put(MediaType.APPLICATION_JSON_UTF8, new ApplicationJsonTransformer());
        this.bodyTransformers.put(MediaType.MULTIPART_FORM_DATA, new MultipartFormTransformer());
        this.bodyTransformers.put("application/hal+json", new ApplicationJsonTransformer());
    }

    Future<Operation> getOperation(String operationId) {
        Operation operation = this.contract.operation(operationId);
        if (operation == null) {
            return Future.failedFuture((Throwable)ValidatorException.createOperationIdInvalid(operationId));
        }
        return Future.succeededFuture((Object)operation);
    }
}

