/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.transformer;

import io.vertx.core.buffer.Buffer;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MultipartPart {
    private static final Pattern NAME_PATTERN = Pattern.compile("Content-Disposition: form-data; name=\"(.*?)\"", 2);
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("Content-Type: (.*)", 2);
    private final String name;
    private final String contentType;
    private final Buffer body;

    static List<MultipartPart> fromMultipartBody(String body, String boundary) {
        return MultipartPart.parseParts(body, boundary).stream().map(MultipartPart::parsePart).collect(Collectors.toList());
    }

    static List<String> parseParts(String body, String boundary) {
        String delimiter = "--" + boundary + "|\r\n--" + boundary;
        String[] rawParts = body.split(delimiter);
        if (rawParts.length < 3 || !"--".equals(rawParts[rawParts.length - 1].trim())) {
            String msg = "The multipart message doesn't contain any parts, or has an invalid structure.";
            throw new ValidatorException(msg, ValidatorErrorType.INVALID_VALUE);
        }
        ArrayList<String> parts = new ArrayList<String>(rawParts.length - 2);
        for (int i = 1; i < rawParts.length - 1; ++i) {
            parts.add(rawParts[i].trim());
        }
        return parts;
    }

    private static Optional<String> parsePattern(Pattern pattern, String rawPart) {
        Matcher m = pattern.matcher(rawPart);
        if (m.find()) {
            return Optional.of(m.toMatchResult().group(1));
        }
        return Optional.ofNullable(null);
    }

    static MultipartPart parsePart(String rawPart) {
        String sectionDelimiterPattern = "\r\n\r\n";
        int sectionDelimiter = rawPart.indexOf(sectionDelimiterPattern);
        String headerSection = sectionDelimiter == -1 ? rawPart : rawPart.substring(0, sectionDelimiter);
        String body = sectionDelimiter == -1 ? null : rawPart.substring(sectionDelimiter + sectionDelimiterPattern.length());
        String name = MultipartPart.parsePattern(NAME_PATTERN, headerSection).orElseThrow(() -> {
            String msg = "A part of the multipart message doesn't contain a name.";
            return new ValidatorException(msg, ValidatorErrorType.INVALID_VALUE);
        });
        String contentType = MultipartPart.parsePattern(CONTENT_TYPE_PATTERN, headerSection).orElse("text/plain");
        return new MultipartPart(name, contentType, body == null ? null : Buffer.buffer((String)body));
    }

    public MultipartPart(String name, String contentType, Buffer body) {
        this.name = name;
        this.contentType = contentType;
        this.body = body;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Buffer getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipartPart that = (MultipartPart)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.contentType, this.body);
    }
}

