/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaValidationException;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.OpenAPIVersion;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Path;
import io.vertx.openapi.contract.SecurityRequirement;
import io.vertx.openapi.contract.SecurityScheme;
import io.vertx.openapi.contract.Server;
import io.vertx.openapi.contract.impl.OpenAPIContractImpl;
import io.vertx.openapi.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@VertxGen
public interface OpenAPIContract {
    public static Future<OpenAPIContract> from(Vertx vertx, String unresolvedContractPath) {
        return Utils.readYamlOrJson(vertx, unresolvedContractPath).compose(json -> OpenAPIContract.from(vertx, json));
    }

    public static Future<OpenAPIContract> from(Vertx vertx, JsonObject unresolvedContract) {
        return OpenAPIContract.from(vertx, unresolvedContract, Collections.emptyMap());
    }

    public static Future<OpenAPIContract> from(Vertx vertx, String unresolvedContractPath, Map<String, String> additionalContractFiles) {
        HashMap<String, Future<JsonObject>> jsonFilesFuture = new HashMap<String, Future<JsonObject>>();
        jsonFilesFuture.put(unresolvedContractPath, Utils.readYamlOrJson(vertx, unresolvedContractPath));
        additionalContractFiles.forEach((key, value) -> jsonFilesFuture.put((String)key, Utils.readYamlOrJson(vertx, value)));
        return Future.all(new ArrayList(jsonFilesFuture.values())).compose(compFut -> {
            HashMap<String, JsonObject> resolvedFiles = new HashMap<String, JsonObject>();
            additionalContractFiles.keySet().forEach(key -> {
                JsonObject cfr_ignored_0 = (JsonObject)resolvedFiles.put((String)key, (JsonObject)((Future)jsonFilesFuture.get(key)).result());
            });
            return OpenAPIContract.from(vertx, (JsonObject)((Future)jsonFilesFuture.get(unresolvedContractPath)).result(), resolvedFiles);
        });
    }

    public static Future<OpenAPIContract> from(Vertx vertx, JsonObject unresolvedContract, Map<String, JsonObject> additionalContractFiles) {
        if (unresolvedContract == null) {
            return Future.failedFuture((Throwable)OpenAPIContractException.createInvalidContract("Spec must not be null"));
        }
        OpenAPIVersion version = OpenAPIVersion.fromContract(unresolvedContract);
        String baseUri = "app://";
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        version.getRepository(vertx, baseUri).compose(repository -> {
            ArrayList<Future> validationFutures = new ArrayList<Future>(additionalContractFiles.size());
            for (String ref : additionalContractFiles.keySet()) {
                JsonObject file = (JsonObject)additionalContractFiles.get(ref);
                Future validationFuture = version.validateAdditionalContractFile(vertx, (SchemaRepository)repository, file).compose(v -> vertx.executeBlocking(() -> repository.dereference(ref, JsonSchema.of((String)ref, (JsonObject)file))));
                validationFutures.add(validationFuture);
            }
            return Future.all(validationFutures).map(repository);
        }).compose(repository -> version.validateContract(vertx, (SchemaRepository)repository, unresolvedContract).compose(res -> {
            try {
                res.checkValidity();
                return version.resolve(vertx, (SchemaRepository)repository, unresolvedContract);
            }
            catch (JsonSchemaValidationException | UnsupportedOperationException e) {
                return Future.failedFuture((Throwable)OpenAPIContractException.createInvalidContract(null, e));
            }
        }).map(resolvedSpec -> new OpenAPIContractImpl((JsonObject)resolvedSpec, version, (SchemaRepository)repository))).recover(e -> {
            if (e instanceof OpenAPIContractException) {
                return Future.failedFuture((Throwable)e);
            }
            return Future.failedFuture((Throwable)OpenAPIContractException.createInvalidContract("Found issue in specification for reference: " + e.getMessage(), e));
        }).onComplete((Handler)promise);
        return promise.future();
    }

    public @Nullable Operation operation(String var1);

    public List<Operation> operations();

    public List<Path> getPaths();

    public JsonObject getRawContract();

    public OpenAPIVersion getVersion();

    public SchemaRepository getSchemaRepository();

    public List<Server> getServers();

    public @Nullable Path findPath(String var1);

    public @Nullable Operation findOperation(String var1, HttpMethod var2);

    public List<SecurityRequirement> getSecurityRequirements();

    public @Nullable SecurityScheme securityScheme(String var1);
}

