/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.validation.RequestParameter;
import io.vertx.openapi.validation.ValidatableRequest;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.impl.RequestParameterImpl;
import io.vertx.openapi.validation.impl.ValidatableRequestImpl;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class RequestUtils {
    private static final RequestParameter EMPTY = new RequestParameterImpl(null);
    private static final Function<Collection<String>, String> GET_FIRST_VALUE = values -> values.stream().findFirst().orElse(null);

    private RequestUtils() {
    }

    public static Future<ValidatableRequest> extract(HttpServerRequest request, Operation operation) {
        return RequestUtils.extract(request, operation, () -> ((HttpServerRequest)request).body());
    }

    public static Future<ValidatableRequest> extract(HttpServerRequest request, Operation operation, Supplier<Future<Buffer>> bodySupplier) {
        HashMap<String, RequestParameter> cookies = new HashMap<String, RequestParameter>();
        HashMap<String, RequestParameter> headers = new HashMap<String, RequestParameter>();
        HashMap<String, RequestParameter> pathParams = new HashMap<String, RequestParameter>();
        HashMap<String, RequestParameter> query = new HashMap<String, RequestParameter>();
        for (Parameter param : operation.getParameters()) {
            switch (param.getIn()) {
                case COOKIE: {
                    cookies.put(param.getName(), RequestUtils.extractCookie(request, param));
                    break;
                }
                case HEADER: {
                    headers.put(param.getName(), RequestUtils.extractHeaders(request, param));
                    break;
                }
                case PATH: {
                    int segment = RequestUtils.findPathSegment(operation.getAbsoluteOpenAPIPath(), param.getName());
                    pathParams.put(param.getName(), RequestUtils.extractPathParameters(request, segment));
                    break;
                }
                case QUERY: {
                    query.put(param.getName(), RequestUtils.extractQuery(request, param));
                }
            }
        }
        if (operation.getRequestBody() == null) {
            return Future.succeededFuture((Object)new ValidatableRequestImpl(cookies, headers, pathParams, query));
        }
        String contentType = request.headers().get(HttpHeaders.CONTENT_TYPE);
        try {
            return bodySupplier.get().map(buffer -> {
                RequestParameterImpl body = new RequestParameterImpl(buffer);
                return new ValidatableRequestImpl(cookies, headers, pathParams, query, body, contentType);
            });
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private static RequestParameter extractCookie(HttpServerRequest request, Parameter parameter) {
        Collection cookies = request.cookies(parameter.getName()).stream().map(Cookie::getValue).collect(Collectors.toList());
        return RequestUtils.joinFormValues(cookies, parameter, () -> {
            String explodedObject = request.cookies().stream().map(c -> c.getName() + "=" + RequestUtils.decodeUrl(c.getValue())).collect(Collectors.joining("&"));
            return new RequestParameterImpl(explodedObject);
        });
    }

    private static RequestParameter extractHeaders(HttpServerRequest request, Parameter parameter) {
        String headerValue = request.getHeader(parameter.getName());
        return new RequestParameterImpl(RequestUtils.decodeUrl(headerValue));
    }

    private static RequestParameter extractPathParameters(HttpServerRequest request, int segment) {
        String[] pathSegments = request.path().substring(1).split("/");
        if (pathSegments.length < segment) {
            return EMPTY;
        }
        return new RequestParameterImpl(RequestUtils.decodeUrl(pathSegments[segment - 1]));
    }

    private static RequestParameter extractQuery(HttpServerRequest request, Parameter parameter) {
        List queryParams = request.params().getAll(parameter.getName());
        return RequestUtils.joinFormValues(queryParams, parameter, () -> {
            String decodedQuery = request.params().entries().stream().map(entry -> (String)entry.getKey() + "=" + RequestUtils.decodeUrl((String)entry.getValue())).collect(Collectors.joining("&"));
            return new RequestParameterImpl(decodedQuery);
        });
    }

    private static RequestParameter joinFormValues(Collection<String> formValues, Parameter parameter, Supplier<RequestParameter> explodedObjectSupplier) {
        if (formValues.isEmpty()) {
            return EMPTY;
        }
        switch (parameter.getSchemaType()) {
            case OBJECT: {
                if (parameter.isExplode()) {
                    return explodedObjectSupplier.get();
                }
                return new RequestParameterImpl(RequestUtils.decodeUrl(GET_FIRST_VALUE.apply(formValues)));
            }
            case ARRAY: {
                if (parameter.isExplode()) {
                    String explodedString = formValues.stream().map(fv -> parameter.getName() + "=" + RequestUtils.decodeUrl(fv)).collect(Collectors.joining("&"));
                    return new RequestParameterImpl(explodedString);
                }
                return new RequestParameterImpl(RequestUtils.decodeUrl(GET_FIRST_VALUE.apply(formValues)));
            }
        }
        return new RequestParameterImpl(RequestUtils.decodeUrl(GET_FIRST_VALUE.apply(formValues)));
    }

    static int findPathSegment(String templatePath, String parameterName) {
        int idx = templatePath.indexOf("{" + parameterName + "}");
        return (int)templatePath.subSequence(0, idx).chars().filter(c -> c == 47).count();
    }

    static String decodeUrl(String encoded) {
        try {
            return encoded == null ? null : URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new ValidatorException("Can't decode URL value: " + encoded, ValidatorErrorType.ILLEGAL_VALUE, e);
        }
    }
}

