/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.openapi.contract.Path;
import io.vertx.openapi.contract.impl.PathImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PathFinder {
    private final Map<Integer, List<PathImpl>> segmentsWithoutTemplating = new HashMap<Integer, List<PathImpl>>();
    private final Map<Integer, Map<Path, String[]>> segmentsWithTemplating = new HashMap<Integer, Map<Path, String[]>>();

    public PathFinder(List<PathImpl> paths) {
        for (PathImpl path : paths) {
            String[] segments = path.getAbsolutePath().substring(1).split("/");
            if (path.getName().contains("{")) {
                this.segmentsWithTemplating.computeIfAbsent(segments.length, i -> new HashMap()).put(path, segments);
                continue;
            }
            this.segmentsWithoutTemplating.computeIfAbsent(segments.length, i -> new ArrayList()).add(path);
        }
    }

    public Path findPath(String path) {
        String[] segments = path.substring(1).split("/");
        for (PathImpl pathImpl : this.segmentsWithoutTemplating.getOrDefault(segments.length, Collections.emptyList())) {
            if (!pathImpl.getAbsolutePath().equals(path)) continue;
            return pathImpl;
        }
        for (Map.Entry entry : this.segmentsWithTemplating.getOrDefault(segments.length, Collections.emptyMap()).entrySet()) {
            if (!this.testSegments(segments, (String[])entry.getValue())) continue;
            return (Path)entry.getKey();
        }
        return null;
    }

    boolean testSegments(String[] pathSegments, String[] pathTemplateSegments) {
        for (int i = 0; i < pathTemplateSegments.length; ++i) {
            String templateSegment = pathTemplateSegments[i];
            if (templateSegment.contains("{") || templateSegment.equals(pathSegments[i])) continue;
            return false;
        }
        return true;
    }
}

