/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.openapi.contract.OAuthFlows;
import io.vertx.openapi.contract.SecurityScheme;
import io.vertx.openapi.contract.impl.OAuthFlowsImpl;

public class SecuritySchemeImpl
implements SecurityScheme {
    private final JsonObject model;
    private final String type;
    private final String name;
    private final String in;
    private final String scheme;
    private final String bearerFormat;
    private final OAuthFlows flows;
    private final String openIdConnectUrl;

    public SecuritySchemeImpl(JsonObject json) {
        this.model = json;
        this.type = json.getString("type");
        this.name = json.getString("name");
        this.in = json.getString("in");
        this.scheme = json.getString("scheme");
        this.bearerFormat = json.getString("bearerFormat");
        this.flows = json.containsKey("flows") ? new OAuthFlowsImpl(json.getJsonObject("flows")) : null;
        this.openIdConnectUrl = json.getString("openIdConnectUrl");
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.model;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getBearerFormat() {
        return this.bearerFormat;
    }

    @Override
    public OAuthFlows getFlows() {
        return this.flows;
    }

    @Override
    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }
}

