/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.transformer;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.validation.ValidatableRequest;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.transformer.BodyTransformer;

public class ApplicationJsonTransformer
implements BodyTransformer {
    @Override
    public Object transformRequest(MediaType type, ValidatableRequest request) {
        return this.transform(type, request.getBody().getBuffer());
    }

    @Override
    public Object transformResponse(MediaType type, ValidatableResponse response) {
        return this.transform(type, response.getBody().getBuffer());
    }

    Object transform(MediaType type, Buffer body) {
        try {
            return Json.decodeValue((Buffer)body);
        }
        catch (DecodeException e) {
            throw new ValidatorException("The request body can't be decoded", ValidatorErrorType.ILLEGAL_VALUE);
        }
    }
}

