/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.transformer;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.validation.ValidatableRequest;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.transformer.ApplicationJsonTransformer;
import io.vertx.openapi.validation.transformer.BodyTransformer;
import io.vertx.openapi.validation.transformer.MultipartPart;
import java.util.List;

public class MultipartFormTransformer
implements BodyTransformer {
    private static final String BOUNDARY = "boundary=";
    private static final ApplicationJsonTransformer JSON_TRANSFORMER = new ApplicationJsonTransformer();

    static String extractBoundary(String contentType) {
        String[] parts = contentType.split(BOUNDARY, 2);
        if (parts.length == 2 && !parts[1].trim().isEmpty()) {
            return parts[1].trim();
        }
        return null;
    }

    static Object transform(MediaType type, Buffer body, String contentType, String responseOrRequest) {
        if (contentType == null || contentType.isEmpty() || !contentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString())) {
            String msg = "The expected multipart/form-data " + responseOrRequest + " doesn't contain the required content-type header.";
            throw new ValidatorException(msg, ValidatorErrorType.MISSING_REQUIRED_PARAMETER);
        }
        String boundary = MultipartFormTransformer.extractBoundary(contentType);
        if (boundary == null) {
            String msg = "The expected multipart/form-data " + responseOrRequest + " doesn't contain the required boundary information.";
            throw new ValidatorException(msg, ValidatorErrorType.MISSING_REQUIRED_PARAMETER);
        }
        JsonObject formData = new JsonObject();
        List<MultipartPart> parts = MultipartPart.fromMultipartBody(body.toString(), boundary);
        for (MultipartPart part : parts) {
            if (part.getBody() == null) continue;
            if (part.getContentType().startsWith("text/plain")) {
                try {
                    formData.put(part.getName(), JSON_TRANSFORMER.transform(null, part.getBody()));
                    continue;
                }
                catch (ValidatorException ve) {
                    if (ve.type() == ValidatorErrorType.ILLEGAL_VALUE) {
                        Buffer quotedBody = Buffer.buffer((String)"\"").appendBuffer(part.getBody()).appendString("\"");
                        formData.put(part.getName(), JSON_TRANSFORMER.transform(null, quotedBody));
                        continue;
                    }
                    throw ve;
                }
            }
            if (part.getContentType().startsWith("application/json")) {
                formData.put(part.getName(), JSON_TRANSFORMER.transform(null, part.getBody()));
                continue;
            }
            if (part.getContentType().startsWith("application/octet-stream")) {
                formData.put(part.getName(), (Object)part.getBody());
                continue;
            }
            String msg = String.format("The content type %s of property %s is not yet supported.", part.getContentType(), part.getName());
            throw new ValidatorException(msg, ValidatorErrorType.UNSUPPORTED_VALUE_FORMAT);
        }
        return formData;
    }

    @Override
    public Object transformRequest(MediaType type, ValidatableRequest request) {
        return MultipartFormTransformer.transform(type, request.getBody().getBuffer(), request.getContentType(), "request");
    }

    @Override
    public Object transformResponse(MediaType type, ValidatableResponse response) {
        return MultipartFormTransformer.transform(type, response.getBody().getBuffer(), response.getContentType(), "response");
    }
}

