/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.impl;

import io.vertx.json.schema.JsonFormatValidator;

public class OpenAPIFormatValidator
implements JsonFormatValidator {
    public String validateFormat(String instanceType, String format, Object instance) {
        if ("int32".equalsIgnoreCase(format) && !(instance instanceof Integer)) {
            return this.getMessage(format);
        }
        if ("int64".equalsIgnoreCase(format) && !(instance instanceof Integer) && !(instance instanceof Long)) {
            return this.getMessage(format);
        }
        if ("float".equalsIgnoreCase(format) && (!(instance instanceof Double) || Float.valueOf(((Double)instance).floatValue()).isInfinite() || Float.valueOf(((Double)instance).floatValue()).isNaN())) {
            return this.getMessage(format);
        }
        if (("float".equalsIgnoreCase(format) || "double".equalsIgnoreCase(format)) && (!(instance instanceof Double) || ((Double)instance).isInfinite() || ((Double)instance).isNaN())) {
            return this.getMessage(format);
        }
        return null;
    }

    private String getMessage(String format) {
        String type = "int32".equalsIgnoreCase(format) || "int64".equalsIgnoreCase(format) ? "Integer" : "Number";
        return String.format("%s does not match the format \"%s\"", type, format);
    }
}

