/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.json.schema.JsonSchema;
import io.vertx.openapi.contract.OpenAPIObject;
import java.util.Arrays;
import java.util.List;

@VertxGen
public interface MediaType
extends OpenAPIObject {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String APPLICATION_HAL_JSON = "application/hal+json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final List<String> SUPPORTED_MEDIA_TYPES = Arrays.asList("application/json", "application/json; charset=utf-8", "multipart/form-data", "application/hal+json", "application/octet-stream");

    public static boolean isMediaTypeSupported(String type) {
        return SUPPORTED_MEDIA_TYPES.contains(type.toLowerCase());
    }

    public JsonSchema getSchema();

    public String getIdentifier();
}

