/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.common.dsl.SchemaType;
import io.vertx.openapi.contract.Location;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.contract.RequestBody;
import io.vertx.openapi.contract.Response;
import io.vertx.openapi.contract.SecurityRequirement;
import io.vertx.openapi.contract.Style;
import io.vertx.openapi.contract.impl.ParameterImpl;
import io.vertx.openapi.contract.impl.RequestBodyImpl;
import io.vertx.openapi.contract.impl.ResponseImpl;
import io.vertx.openapi.contract.impl.SecurityRequirementImpl;
import io.vertx.openapi.impl.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OperationImpl
implements Operation {
    private static final Logger LOG = LoggerFactory.getLogger(OperationImpl.class);
    private static final Pattern RESPONSE_CODE_PATTERN = Pattern.compile("\\d\\d\\d");
    private static final String KEY_OPERATION_ID = "operationId";
    private static final String KEY_TAGS = "tags";
    private static final String KEY_PARAMETERS = "parameters";
    private static final String KEY_REQUEST_BODY = "requestBody";
    private static final String KEY_RESPONSES = "responses";
    private static final String KEY_SECURITY = "security";
    private final String operationId;
    private final String path;
    private final HttpMethod method;
    private final JsonObject operationModel;
    private final List<Parameter> parameters;
    private final RequestBody requestBody;
    private final List<String> tags;
    private final Response defaultResponse;
    private final Map<Integer, Response> responses;
    private final String absolutePath;
    private final List<SecurityRequirement> securityRequirements;
    private final Map<String, Object> extensions;

    public OperationImpl(String absolutePath, String path, HttpMethod method, JsonObject operationModel, List<Parameter> pathParameters, Map<String, Object> pathExtensions, List<SecurityRequirement> globalSecReq) {
        this.absolutePath = absolutePath;
        this.operationId = operationModel.getString(KEY_OPERATION_ID);
        this.method = method;
        this.path = path;
        this.operationModel = operationModel;
        HashMap<String, Object> allExtensions = new HashMap<String, Object>(Operation.super.getExtensions());
        pathExtensions.forEach(allExtensions::putIfAbsent);
        this.extensions = Collections.unmodifiableMap(allExtensions);
        this.tags = operationModel.getJsonArray(KEY_TAGS, Utils.EMPTY_JSON_ARRAY).stream().map(Object::toString).collect(Collectors.toUnmodifiableList());
        this.securityRequirements = operationModel.containsKey(KEY_SECURITY) ? operationModel.getJsonArray(KEY_SECURITY).stream().map(JsonObject.class::cast).map(SecurityRequirementImpl::new).collect(Collectors.toUnmodifiableList()) : globalSecReq;
        List<Parameter> operationParameters = ParameterImpl.parseParameters(path, operationModel.getJsonArray(KEY_PARAMETERS, Utils.EMPTY_JSON_ARRAY));
        for (Parameter pathParam : pathParameters) {
            Optional<Parameter> parameterDuplicate = operationParameters.stream().filter(param -> pathParam.getName().equals(param.getName()) && pathParam.getIn().equals((Object)param.getIn())).findAny();
            if (parameterDuplicate.isPresent()) {
                LOG.debug((Object)("Found ambiguous parameter (" + pathParam.getName() + ") in operation: " + this.operationId));
                continue;
            }
            operationParameters.add(pathParam);
        }
        long explodedQueryParams = operationParameters.stream().filter(p -> p.isExplode() && p.getStyle() == Style.FORM && p.getIn() == Location.QUERY && p.getSchemaType() == SchemaType.OBJECT).count();
        if (explodedQueryParams > 1L) {
            String msg = "Found multiple exploded query parameters of style form with type object in operation: " + this.operationId;
            throw OpenAPIContractException.createInvalidContract(msg);
        }
        this.parameters = Collections.unmodifiableList(operationParameters);
        JsonObject requestBodyJson = operationModel.getJsonObject(KEY_REQUEST_BODY);
        this.requestBody = requestBodyJson == null || requestBodyJson.isEmpty() ? null : new RequestBodyImpl(requestBodyJson, this.operationId);
        JsonObject responsesJson = operationModel.getJsonObject(KEY_RESPONSES, Utils.EMPTY_JSON_OBJECT);
        if (responsesJson.isEmpty()) {
            String msg = "No responses were found in operation: " + this.operationId;
            throw OpenAPIContractException.createInvalidContract(msg);
        }
        this.defaultResponse = responsesJson.stream().filter(entry -> "default".equalsIgnoreCase((String)entry.getKey())).findFirst().map(entry -> new ResponseImpl((JsonObject)entry.getValue(), this.operationId)).orElse(null);
        this.responses = Collections.unmodifiableMap(responsesJson.fieldNames().stream().filter(JsonSchema.EXCLUDE_ANNOTATIONS).filter(RESPONSE_CODE_PATTERN.asPredicate()).collect(Collectors.toMap(Integer::parseInt, key -> new ResponseImpl(responsesJson.getJsonObject(key), this.operationId))));
    }

    @Override
    public String getOperationId() {
        return this.operationId;
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.operationModel;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    public String getOpenAPIPath() {
        return this.path;
    }

    @Override
    public String getAbsoluteOpenAPIPath() {
        return this.absolutePath;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    @Override
    public Response getDefaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public Response getResponse(int responseCode) {
        return this.responses.get(responseCode);
    }

    @Override
    public List<SecurityRequirement> getSecurityRequirements() {
        return this.securityRequirements;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }
}

