/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.analyser;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.openapi.validation.ValidationContext;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.analyser.ContentAnalyser;
import io.vertx.openapi.validation.analyser.MultipartPart;
import java.util.List;

public class MultipartFormAnalyser
extends ContentAnalyser {
    private static final String BOUNDARY = "boundary=";
    private List<MultipartPart> parts;

    public MultipartFormAnalyser(String contentType, Buffer content, ValidationContext context) {
        super(contentType, content, context);
    }

    public static String extractBoundary(String contentType) {
        String[] parts = contentType.split(BOUNDARY, 2);
        if (parts.length == 2 && !parts[1].isBlank()) {
            return parts[1].strip();
        }
        return null;
    }

    @Override
    public void checkSyntacticalCorrectness() {
        if (this.contentType == null || this.contentType.isEmpty() || !this.contentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString())) {
            String msg = "The expected multipart/form-data " + this.requestOrResponse + " doesn't contain the required content-type header.";
            throw new ValidatorException(msg, ValidatorErrorType.MISSING_REQUIRED_PARAMETER);
        }
        String boundary = MultipartFormAnalyser.extractBoundary(this.contentType);
        if (boundary == null) {
            String msg = "The expected multipart/form-data " + this.requestOrResponse + " doesn't contain the required boundary information.";
            throw new ValidatorException(msg, ValidatorErrorType.MISSING_REQUIRED_PARAMETER);
        }
        this.parts = MultipartPart.fromMultipartBody(this.content.toString(), boundary);
    }

    @Override
    public Object transform() {
        JsonObject formData = new JsonObject();
        for (MultipartPart part : this.parts) {
            if (part.getBody() == null) continue;
            if (part.getContentType().startsWith("text/plain")) {
                try {
                    formData.put(part.getName(), Json.decodeValue((Buffer)part.getBody()));
                }
                catch (DecodeException de) {
                    Buffer quotedBody = Buffer.buffer((String)"\"").appendBuffer(part.getBody()).appendString("\"");
                    formData.put(part.getName(), MultipartFormAnalyser.decodeJsonContent(quotedBody, this.requestOrResponse));
                }
                continue;
            }
            if (part.getContentType().startsWith("application/json")) {
                formData.put(part.getName(), MultipartFormAnalyser.decodeJsonContent(part.getBody(), this.requestOrResponse));
                continue;
            }
            if (part.getContentType().startsWith("application/octet-stream")) {
                formData.put(part.getName(), (Object)part.getBody());
                continue;
            }
            String msg = String.format("The content type %s of property %s is not yet supported.", part.getContentType(), part.getName());
            throw new ValidatorException(msg, ValidatorErrorType.UNSUPPORTED_VALUE_FORMAT);
        }
        return formData;
    }
}

