/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.json.schema.JsonSchemaValidationException;
import io.vertx.json.schema.OutputUnit;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.SchemaValidationException;
import io.vertx.openapi.validation.ValidationContext;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.analyser.ContentAnalyser;
import io.vertx.openapi.validation.impl.RequestParameterImpl;

public class BaseValidator {
    protected final Vertx vertx;
    protected final OpenAPIContract contract;

    public BaseValidator(Vertx vertx, OpenAPIContract contract) {
        this.vertx = vertx;
        this.contract = contract;
    }

    protected Future<Operation> getOperation(String operationId) {
        Operation operation = this.contract.operation(operationId);
        if (operation == null) {
            return Future.failedFuture((Throwable)ValidatorException.createOperationIdInvalid(operationId));
        }
        return Future.succeededFuture((Object)operation);
    }

    protected boolean isSchemaValidationRequired(MediaType mediaType) {
        boolean noFurtherProperties;
        if (mediaType.getSchema() == null) {
            return false;
        }
        String type = (String)mediaType.getSchema().get("type");
        String format = (String)mediaType.getSchema().get("format");
        boolean bl = noFurtherProperties = mediaType.getSchema().fieldNames().size() == 2;
        return !"string".equalsIgnoreCase(type) || !"binary".equalsIgnoreCase(format) || !noFurtherProperties;
    }

    protected RequestParameterImpl validate(MediaType mediaType, String contentType, Buffer rawContent, ValidationContext requestOrResponse) {
        ContentAnalyser contentAnalyser;
        ContentAnalyser contentAnalyser2 = contentAnalyser = mediaType == null ? null : ContentAnalyser.getContentAnalyser(mediaType, contentType, rawContent, requestOrResponse);
        if (contentAnalyser == null) {
            throw new ValidatorException("The format of the " + requestOrResponse + " body is not supported", ValidatorErrorType.UNSUPPORTED_VALUE_FORMAT);
        }
        contentAnalyser.checkSyntacticalCorrectness();
        if (this.isSchemaValidationRequired(mediaType)) {
            Object transformedValue = contentAnalyser.transform();
            OutputUnit result = this.contract.getSchemaRepository().validator(mediaType.getSchema()).validate(transformedValue);
            try {
                result.checkValidity();
                return new RequestParameterImpl(transformedValue);
            }
            catch (JsonSchemaValidationException e) {
                throw SchemaValidationException.createInvalidValueBody(result, requestOrResponse, e);
            }
        }
        return new RequestParameterImpl(rawContent);
    }
}

