/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.transformer;

import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.transformer.ParameterTransformer;

public class LabelTransformer
extends ParameterTransformer {
    private static boolean startsWithDot(String value) {
        return '.' == value.charAt(0);
    }

    @Override
    public Object transform(Parameter parameter, String rawValue) {
        if (!rawValue.isEmpty() && LabelTransformer.startsWithDot(rawValue)) {
            return super.transform(parameter, rawValue.substring(1));
        }
        throw ValidatorException.createInvalidValueFormat(parameter);
    }

    @Override
    protected String[] getArrayValues(Parameter parameter, String rawValue) {
        return parameter.isExplode() ? rawValue.split("\\.") : rawValue.split(",");
    }

    @Override
    protected String[] getObjectKeysAndValues(Parameter parameter, String rawValue) {
        return parameter.isExplode() ? rawValue.split("[=|.]") : rawValue.split(",");
    }
}

