/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.openapi.contract.Path;
import io.vertx.openapi.contract.impl.PathImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathFinder {
    private final Map<Integer, List<PathImpl>> segmentsWithoutTemplating = new HashMap<Integer, List<PathImpl>>();
    private final Map<Integer, Map<Path, String[]>> segmentsWithTemplating = new HashMap<Integer, Map<Path, String[]>>();

    public PathFinder(List<PathImpl> paths) {
        for (PathImpl path : paths) {
            String[] segments = path.getAbsolutePath().substring(1).split("/");
            if (path.getName().contains("{")) {
                this.segmentsWithTemplating.computeIfAbsent(segments.length, i -> new HashMap()).put(path, segments);
                continue;
            }
            this.segmentsWithoutTemplating.computeIfAbsent(segments.length, i -> new ArrayList()).add(path);
        }
    }

    public Path findPath(String path) {
        String[] segments = path.substring(1).split("/");
        for (PathImpl p : this.segmentsWithoutTemplating.getOrDefault(segments.length, Collections.emptyList())) {
            if (!p.getAbsolutePath().equals(path)) continue;
            return p;
        }
        Path bestMatchedPath = null;
        int currentMatchedSegments = -1;
        for (Map.Entry entry : this.segmentsWithTemplating.getOrDefault(segments.length, Collections.emptyMap()).entrySet()) {
            int matchedSegments = this.testSegments(segments, (String[])entry.getValue());
            if (matchedSegments <= currentMatchedSegments) continue;
            bestMatchedPath = (Path)entry.getKey();
            currentMatchedSegments = matchedSegments;
        }
        return bestMatchedPath;
    }

    public int testSegments(String[] pathSegments, String[] pathTemplateSegments) {
        int numPerfectMatches = 0;
        for (int i = 0; i < pathTemplateSegments.length; ++i) {
            String templateSegment = pathTemplateSegments[i];
            if (templateSegment.contains("{")) continue;
            if (templateSegment.equals(pathSegments[i])) {
                numPerfectMatches += pathTemplateSegments.length - i;
                continue;
            }
            return -1;
        }
        return numPerfectMatches;
    }
}

