/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.openapi.impl.OpenAPIYamlConstructor;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public final class Utils {
    public static final JsonArray EMPTY_JSON_ARRAY = new JsonArray(Collections.emptyList());
    public static final JsonObject EMPTY_JSON_OBJECT = new JsonObject(Collections.emptyMap());

    private Utils() {
    }

    public static Future<JsonObject> readYamlOrJson(Vertx vertx, String path) {
        return vertx.fileSystem().readFile(path).compose(buff -> {
            String suffix = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
            if ("json".equals(suffix)) {
                return Future.succeededFuture((Object)buff.toJsonObject());
            }
            if ("yaml".equals(suffix) || "yml".equals(suffix)) {
                return Utils.yamlStringToJson(buff.toString(StandardCharsets.UTF_8));
            }
            return Future.failedFuture((Throwable)new IllegalArgumentException("Only JSON or YAML files are allowed"));
        });
    }

    public static Future<JsonObject> yamlStringToJson(String yamlString) {
        try {
            Yaml yaml = new Yaml((BaseConstructor)new OpenAPIYamlConstructor());
            Map doc = (Map)yaml.load(yamlString);
            return Future.succeededFuture((Object)new JsonObject(Utils.jsonify(doc)));
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private static Map<String, Object> jsonify(Map<Object, Object> yaml) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> kv : yaml.entrySet()) {
            Map<String, Object> value = kv.getValue();
            if (value instanceof Map) {
                value = Utils.jsonify((Map<Object, Object>)value);
            }
            json.put(kv.getKey().toString(), value);
        }
        return json;
    }
}

