/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.json.schema.JsonSchemaValidationException;
import io.vertx.json.schema.OutputUnit;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.contract.OpenAPIContract;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.contract.RequestBody;
import io.vertx.openapi.contract.Style;
import io.vertx.openapi.validation.RequestParameter;
import io.vertx.openapi.validation.RequestValidator;
import io.vertx.openapi.validation.SchemaValidationException;
import io.vertx.openapi.validation.ValidatableRequest;
import io.vertx.openapi.validation.ValidatedRequest;
import io.vertx.openapi.validation.ValidationContext;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.impl.BaseValidator;
import io.vertx.openapi.validation.impl.RequestParameterImpl;
import io.vertx.openapi.validation.impl.ValidatedRequestImpl;
import io.vertx.openapi.validation.transformer.FormTransformer;
import io.vertx.openapi.validation.transformer.LabelTransformer;
import io.vertx.openapi.validation.transformer.MatrixTransformer;
import io.vertx.openapi.validation.transformer.ParameterTransformer;
import io.vertx.openapi.validation.transformer.SimpleTransformer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class RequestValidatorImpl
extends BaseValidator
implements RequestValidator {
    private final Map<Style, ParameterTransformer> parameterTransformers = new EnumMap<Style, ParameterTransformer>(Style.class);

    public RequestValidatorImpl(Vertx vertx, OpenAPIContract contract) {
        super(vertx, contract);
        this.parameterTransformers.put(Style.SIMPLE, new SimpleTransformer());
        this.parameterTransformers.put(Style.LABEL, new LabelTransformer());
        this.parameterTransformers.put(Style.MATRIX, new MatrixTransformer());
        this.parameterTransformers.put(Style.FORM, new FormTransformer());
    }

    @Override
    public Future<ValidatedRequest> validate(HttpServerRequest request) {
        Operation operation = this.contract.findOperation(request.path(), request.method());
        if (operation == null) {
            return Future.failedFuture((Throwable)ValidatorException.createOperationNotFound(request.method(), request.path()));
        }
        return this.validate(request, operation.getOperationId());
    }

    @Override
    public Future<ValidatedRequest> validate(HttpServerRequest request, String operationId) {
        return this.getOperation(operationId).compose(op -> ValidatableRequest.of(request, op)).compose(params -> this.validate((ValidatableRequest)params, operationId));
    }

    @Override
    public Future<ValidatedRequest> validate(ValidatableRequest request, String operationId) {
        return this.getOperation(operationId).compose(operation -> this.vertx.executeBlocking(() -> {
            HashMap<String, RequestParameter> cookies = new HashMap<String, RequestParameter>(request.getCookies().size());
            HashMap<String, RequestParameter> headers = new HashMap<String, RequestParameter>(request.getHeaders().size());
            HashMap<String, RequestParameter> path = new HashMap<String, RequestParameter>(request.getPathParameters().size());
            HashMap<String, RequestParameter> query = new HashMap<String, RequestParameter>(request.getQuery().size());
            for (Parameter param : operation.getParameters()) {
                switch (param.getIn()) {
                    case COOKIE: {
                        cookies.put(param.getName(), this.validateParameter(param, request.getCookies().get(param.getName())));
                        break;
                    }
                    case HEADER: {
                        headers.put(param.getName(), this.validateParameter(param, request.getHeaders().get(param.getName())));
                        break;
                    }
                    case PATH: {
                        path.put(param.getName(), this.validateParameter(param, request.getPathParameters().get(param.getName())));
                        break;
                    }
                    case QUERY: {
                        query.put(param.getName(), this.validateParameter(param, request.getQuery().get(param.getName())));
                    }
                }
            }
            RequestParameter body = this.validateBody(operation.getRequestBody(), request);
            return new ValidatedRequestImpl(cookies, headers, path, query, body);
        }));
    }

    public RequestParameter validateParameter(Parameter parameter, RequestParameter value) throws ValidatorException {
        if (value == null || value.isNull()) {
            if (parameter.isRequired()) {
                throw ValidatorException.createMissingRequiredParameter(parameter);
            }
            return new RequestParameterImpl(null);
        }
        ParameterTransformer transformer = this.parameterTransformers.get((Object)parameter.getStyle());
        if (transformer == null) {
            throw ValidatorException.createUnsupportedValueFormat(parameter);
        }
        Object transformedValue = transformer.transform(parameter, String.valueOf(value.get()));
        OutputUnit result = this.contract.getSchemaRepository().validator(parameter.getSchema()).validate(transformedValue);
        try {
            result.checkValidity();
            return new RequestParameterImpl(transformedValue);
        }
        catch (JsonSchemaValidationException e) {
            throw SchemaValidationException.createErrorFromOutputUnitType(parameter, result, e);
        }
    }

    public RequestParameter validateBody(RequestBody requestBody, ValidatableRequest request) {
        if (requestBody == null) {
            return new RequestParameterImpl(null);
        }
        if (request.getBody() == null || request.getBody().isEmpty()) {
            if (requestBody.isRequired()) {
                throw new ValidatorException("The related request does not contain the required body.", ValidatorErrorType.MISSING_REQUIRED_PARAMETER);
            }
            return new RequestParameterImpl(null);
        }
        MediaType mediaType = requestBody.determineContentType(request.getContentType());
        Buffer content = request.getBody().getBuffer(Buffer.buffer());
        return this.validate(mediaType, request.getContentType(), content, ValidationContext.REQUEST);
    }
}

