/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.analyser;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.validation.ValidationContext;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.analyser.ApplicationJsonAnalyser;
import io.vertx.openapi.validation.analyser.MultipartFormAnalyser;

public abstract class ContentAnalyser {
    protected final String contentType;
    protected final Buffer content;
    protected final ValidationContext requestOrResponse;

    public static ContentAnalyser getContentAnalyser(MediaType mediaType, String contentType, Buffer content, ValidationContext context) {
        switch (mediaType.getIdentifier()) {
            case "application/json": 
            case "application/json; charset=utf-8": 
            case "application/hal+json": {
                return new ApplicationJsonAnalyser(contentType, content, context);
            }
            case "multipart/form-data": {
                return new MultipartFormAnalyser(contentType, content, context);
            }
            case "application/octet-stream": 
            case "text/plain": 
            case "text/plain; charset=utf-8": {
                return new NoOpAnalyser(contentType, content, context);
            }
        }
        if (MediaType.isVendorSpecificJson(contentType)) {
            return new ApplicationJsonAnalyser(contentType, content, context);
        }
        return null;
    }

    public ContentAnalyser(String contentType, Buffer content, ValidationContext context) {
        this.contentType = contentType;
        this.content = content;
        this.requestOrResponse = context;
    }

    public abstract void checkSyntacticalCorrectness();

    public abstract Object transform();

    protected static ValidatorException buildSyntaxException(String message) {
        return new ValidatorException(message, ValidatorErrorType.ILLEGAL_VALUE);
    }

    protected static Object decodeJsonContent(Buffer content, ValidationContext requestOrResponse) {
        try {
            return Json.decodeValue((Buffer)content);
        }
        catch (DecodeException e) {
            throw ContentAnalyser.buildSyntaxException("The " + String.valueOf((Object)requestOrResponse) + " body can't be decoded");
        }
    }

    private static class NoOpAnalyser
    extends ContentAnalyser {
        public NoOpAnalyser(String contentType, Buffer content, ValidationContext context) {
            super(contentType, content, context);
        }

        @Override
        public void checkSyntacticalCorrectness() {
        }

        @Override
        public Object transform() {
            return this.content;
        }
    }
}

