/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.json.schema.JsonSchema;
import io.vertx.openapi.contract.OpenAPIObject;
import io.vertx.openapi.contract.impl.VendorSpecificJson;
import java.util.List;

@VertxGen
public interface MediaType
extends OpenAPIObject {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String APPLICATION_HAL_JSON = "application/hal+json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_PLAIN_UTF8 = "text/plain; charset=utf-8";
    public static final List<String> SUPPORTED_MEDIA_TYPES = List.of("application/json", "application/json; charset=utf-8", "multipart/form-data", "application/hal+json", "application/octet-stream", "text/plain", "text/plain; charset=utf-8");

    public static boolean isMediaTypeSupported(String type) {
        return SUPPORTED_MEDIA_TYPES.contains(type.toLowerCase()) || MediaType.isVendorSpecificJson(type);
    }

    public static boolean isVendorSpecificJson(String type) {
        return VendorSpecificJson.matches(type);
    }

    public JsonSchema getSchema();

    public String getIdentifier();
}

