/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation;

import io.vertx.core.http.HttpMethod;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.validation.ValidatorErrorType;

public class ValidatorException
extends RuntimeException {
    private final ValidatorErrorType type;

    public ValidatorException(String message, ValidatorErrorType type) {
        this(message, type, null);
    }

    protected ValidatorException(String message, ValidatorErrorType type, Throwable cause) {
        super(message, cause);
        this.type = type;
    }

    public static ValidatorException createMissingRequiredParameter(Parameter parameter) {
        String msg = String.format("The related request / response does not contain the required %s parameter %s", parameter.getIn().name().toLowerCase(), parameter.getName());
        return new ValidatorException(msg, ValidatorErrorType.MISSING_REQUIRED_PARAMETER);
    }

    public static ValidatorException createInvalidValueFormat(Parameter parameter) {
        String msg = String.format("The formatting of the value of %s parameter %s doesn't match to style %s.", new Object[]{parameter.getIn().name().toLowerCase(), parameter.getName(), parameter.getStyle()});
        return new ValidatorException(msg, ValidatorErrorType.INVALID_VALUE_FORMAT);
    }

    public static ValidatorException createUnsupportedValueFormat(Parameter parameter) {
        String msg = String.format("Values in style %s with exploded=%s are not supported for %s parameter %s.", new Object[]{parameter.getStyle(), parameter.isExplode(), parameter.getIn().name().toLowerCase(), parameter.getName()});
        return new ValidatorException(msg, ValidatorErrorType.UNSUPPORTED_VALUE_FORMAT);
    }

    public static ValidatorException createCantDecodeValue(Parameter parameter) {
        String msg = String.format("The value of %s parameter %s can't be decoded.", parameter.getIn().name().toLowerCase(), parameter.getName());
        return new ValidatorException(msg, ValidatorErrorType.ILLEGAL_VALUE);
    }

    public static ValidatorException createOperationIdInvalid(String operationId) {
        String msg = String.format("Invalid OperationId: %s", operationId);
        return new ValidatorException(msg, ValidatorErrorType.MISSING_OPERATION);
    }

    public static ValidatorException createOperationNotFound(HttpMethod method, String path) {
        String msg = String.format("No operation found for the request: %s %s", method.name(), path);
        return new ValidatorException(msg, ValidatorErrorType.MISSING_OPERATION);
    }

    public static ValidatorException createResponseNotFound(int statusCode, String operation) {
        String msg = String.format("No response defined for status code %s in Operation %s", statusCode, operation);
        return new ValidatorException(msg, ValidatorErrorType.MISSING_RESPONSE);
    }

    public ValidatorErrorType type() {
        return this.type;
    }
}

