/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.RequestBody;
import io.vertx.openapi.contract.impl.MediaTypeImpl;
import io.vertx.openapi.impl.Utils;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestBodyImpl
implements RequestBody {
    private static final String KEY_REQUIRED = "required";
    private static final String KEY_CONTENT = "content";
    private final JsonObject requestBodyModel;
    private final boolean required;
    private final Map<String, MediaType> content;

    public RequestBodyImpl(JsonObject requestBodyModel, String operationId) {
        this.requestBodyModel = requestBodyModel;
        this.required = requestBodyModel.getBoolean(KEY_REQUIRED, Boolean.valueOf(false));
        JsonObject contentObject = requestBodyModel.getJsonObject(KEY_CONTENT, Utils.EMPTY_JSON_OBJECT);
        this.content = Collections.unmodifiableMap(contentObject.fieldNames().stream().filter(JsonSchema.EXCLUDE_ANNOTATIONS).filter(mediaTypeIdentifier -> {
            if (MediaType.isMediaTypeSupported(mediaTypeIdentifier)) {
                return true;
            }
            String msgTemplate = "Operation %s defines a request body with an unsupported media type. Supported: %s";
            throw OpenAPIContractException.createUnsupportedFeature(String.format(msgTemplate, operationId, String.join((CharSequence)", ", MediaType.SUPPORTED_MEDIA_TYPES)));
        }).collect(Collectors.toMap(this::removeWhiteSpaces, key -> new MediaTypeImpl((String)key, contentObject.getJsonObject(key)))));
        if (this.content.isEmpty()) {
            String msg = String.format("Operation %s defines a request body without or with empty property \"content\"", operationId);
            throw OpenAPIContractException.createInvalidContract(msg);
        }
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.requestBodyModel;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public Map<String, MediaType> getContent() {
        return this.content;
    }

    @Override
    public MediaType determineContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        String condensedIdentifier = this.removeWhiteSpaces(contentType);
        if (this.content.containsKey(condensedIdentifier)) {
            return this.content.get(condensedIdentifier);
        }
        for (Map.Entry<String, MediaType> declaredType : this.content.entrySet()) {
            if (!condensedIdentifier.startsWith(this.removeWhiteSpaces(declaredType.getKey()))) continue;
            return declaredType.getValue();
        }
        return null;
    }

    private String removeWhiteSpaces(String s) {
        return s.replaceAll("\\s+", "");
    }
}

