/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.contract.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.openapi.contract.Location;
import io.vertx.openapi.contract.MediaType;
import io.vertx.openapi.contract.OpenAPIContractException;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.contract.Response;
import io.vertx.openapi.contract.impl.MediaTypeImpl;
import io.vertx.openapi.contract.impl.ParameterImpl;
import io.vertx.openapi.impl.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ResponseImpl
implements Response {
    private static final String KEY_HEADERS = "headers";
    private static final String KEY_CONTENT = "content";
    private static final Predicate<String> FILTER_CONTENT_TYPE = name -> !name.equalsIgnoreCase(HttpHeaderNames.CONTENT_TYPE.toString());
    private final List<Parameter> headers;
    private final Map<String, MediaType> content;
    private final JsonObject responseModel;

    public ResponseImpl(JsonObject responseModel, String operationId) {
        this.responseModel = responseModel;
        JsonObject headersObject = responseModel.getJsonObject(KEY_HEADERS, Utils.EMPTY_JSON_OBJECT);
        this.headers = headersObject.fieldNames().stream().filter(JsonSchema.EXCLUDE_ANNOTATIONS).filter(FILTER_CONTENT_TYPE).map(name -> {
            JsonObject headerModel = headersObject.getJsonObject(name).copy().put("name", name).put("in", (Object)Location.HEADER.toString());
            return new ParameterImpl("", headerModel);
        }).collect(Collectors.toUnmodifiableList());
        JsonObject contentObject = responseModel.getJsonObject(KEY_CONTENT, Utils.EMPTY_JSON_OBJECT);
        this.content = Collections.unmodifiableMap(contentObject.fieldNames().stream().filter(JsonSchema.EXCLUDE_ANNOTATIONS).collect(Collectors.toMap(Function.identity(), key -> new MediaTypeImpl((String)key, contentObject.getJsonObject(key)))));
        if (this.content.keySet().stream().anyMatch(type -> !MediaType.isMediaTypeSupported(type))) {
            String msgTemplate = "Operation %s defines a response with an unsupported media type. Supported: %s";
            throw OpenAPIContractException.createUnsupportedFeature(String.format(msgTemplate, operationId, String.join((CharSequence)", ", MediaType.SUPPORTED_MEDIA_TYPES)));
        }
    }

    @Override
    public JsonObject getOpenAPIModel() {
        return this.responseModel;
    }

    @Override
    public List<Parameter> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, MediaType> getContent() {
        return this.content;
    }
}

