/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation;

import io.vertx.json.schema.JsonSchemaValidationException;
import io.vertx.json.schema.OutputUnit;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.validation.ValidationContext;
import io.vertx.openapi.validation.ValidatorErrorType;
import io.vertx.openapi.validation.ValidatorException;

public class SchemaValidationException
extends ValidatorException {
    private final OutputUnit outputUnit;

    public SchemaValidationException(String message, ValidatorErrorType type, OutputUnit outputUnit, Throwable cause) {
        super(message, type, cause);
        this.outputUnit = outputUnit;
    }

    public static SchemaValidationException createInvalidValueParameter(Parameter parameter, OutputUnit outputUnit, JsonSchemaValidationException cause) {
        String msg = String.format("The value of %s parameter %s is invalid. Reason: %s", parameter.getIn().name().toLowerCase(), parameter.getName(), SchemaValidationException.extractReason(outputUnit));
        return new SchemaValidationException(msg, ValidatorErrorType.INVALID_VALUE, outputUnit, (Throwable)cause);
    }

    public static SchemaValidationException createInvalidValueBody(OutputUnit outputUnit, ValidationContext requestOrResponse, JsonSchemaValidationException cause) {
        String msg = String.format("The value of the " + String.valueOf((Object)requestOrResponse) + " body is invalid. Reason: %s", SchemaValidationException.extractReason(outputUnit));
        return new SchemaValidationException(msg, ValidatorErrorType.INVALID_VALUE, outputUnit, (Throwable)cause);
    }

    public static SchemaValidationException createMissingValueRequestBody(OutputUnit outputUnit, JsonSchemaValidationException cause) {
        String msg = String.format("The value of the request body is missing. Reason: %s", SchemaValidationException.extractReason(outputUnit));
        return new SchemaValidationException(msg, ValidatorErrorType.MISSING_REQUIRED_PARAMETER, outputUnit, (Throwable)cause);
    }

    public static SchemaValidationException createErrorFromOutputUnitType(Parameter parameter, OutputUnit outputUnit, JsonSchemaValidationException cause) {
        switch (outputUnit.getErrorType()) {
            case MISSING_VALUE: {
                return SchemaValidationException.createMissingValueRequestBody(outputUnit, cause);
            }
        }
        return SchemaValidationException.createInvalidValueParameter(parameter, outputUnit, cause);
    }

    public OutputUnit getOutputUnit() {
        return this.outputUnit;
    }

    static String extractReason(OutputUnit outputUnit) {
        OutputUnit mostRelevant = (OutputUnit)outputUnit.getErrors().get(outputUnit.getErrors().size() - 1);
        String location = mostRelevant.getInstanceLocation();
        return mostRelevant.getError() + (String)(location.length() > 1 ? " at " + location : "");
    }
}

