/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.openapi.validation.ResponseParameter;
import io.vertx.openapi.validation.impl.RequestParameterImpl;
import io.vertx.openapi.validation.impl.ValidatableResponseImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@VertxGen
public interface ValidatableResponse {
    public static ValidatableResponse create(int statusCode) {
        return ValidatableResponse.create(statusCode, null, null, null);
    }

    public static ValidatableResponse create(int statusCode, Map<String, String> headers) {
        return ValidatableResponse.create(statusCode, headers, null, null);
    }

    public static ValidatableResponse create(int statusCode, Buffer body, String contentType) {
        return ValidatableResponse.create(statusCode, null, body, contentType);
    }

    public static ValidatableResponse create(int statusCode, Map<String, String> headers, Buffer body, String contentType) {
        Map<String, ResponseParameter> transformedHeaders = Optional.ofNullable(headers).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), entry -> new RequestParameterImpl(entry.getValue())));
        if (body != null && contentType == null) {
            throw new IllegalArgumentException("When a body is passed, the content type MUST be specified");
        }
        return new ValidatableResponseImpl(statusCode, transformedHeaders, new RequestParameterImpl(body), contentType);
    }

    public Map<String, ResponseParameter> getHeaders();

    public ResponseParameter getBody();

    public @Nullable String getContentType();

    public int getStatusCode();
}

