/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.transformer;

import io.vertx.json.schema.common.dsl.SchemaType;
import io.vertx.openapi.contract.Parameter;
import io.vertx.openapi.validation.ValidatorException;
import io.vertx.openapi.validation.transformer.ParameterTransformer;

public class MatrixTransformer
extends ParameterTransformer {
    public String buildPrefix(Parameter parameter) {
        if (parameter.isExplode() && parameter.getSchemaType() == SchemaType.OBJECT) {
            return ";";
        }
        return ";" + parameter.getName() + "=";
    }

    @Override
    public Object transform(Parameter parameter, String rawValue) {
        String prefix = this.buildPrefix(parameter);
        if (!rawValue.isEmpty() && rawValue.startsWith(prefix)) {
            return super.transform(parameter, rawValue.substring(prefix.length()));
        }
        throw ValidatorException.createInvalidValueFormat(parameter);
    }

    @Override
    protected String[] getArrayValues(Parameter parameter, String rawValue) {
        return parameter.isExplode() ? rawValue.split(this.buildPrefix(parameter)) : rawValue.split(",");
    }

    @Override
    protected String[] getObjectKeysAndValues(Parameter parameter, String rawValue) {
        return parameter.isExplode() ? rawValue.split("(" + this.buildPrefix(parameter) + "|=)") : rawValue.split(",");
    }
}

