/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.ContextStorageProvider;
import io.opentelemetry.context.Scope;
import io.vertx.core.Vertx;

public class VertxContextStorageProvider
implements ContextStorageProvider {
    static String ACTIVE_CONTEXT = "tracing.context";

    public ContextStorage get() {
        return VertxContextStorage.INSTANCE;
    }

    static enum VertxContextStorage implements ContextStorage
    {
        INSTANCE;


        public Scope attach(Context toAttach) {
            return this.attach(Vertx.currentContext(), toAttach);
        }

        public Scope attach(io.vertx.core.Context vertxCtx, Context toAttach) {
            Context current = (Context)vertxCtx.getLocal((Object)ACTIVE_CONTEXT);
            if (current == toAttach) {
                return Scope.noop();
            }
            vertxCtx.putLocal((Object)ACTIVE_CONTEXT, (Object)toAttach);
            if (current == null) {
                return () -> vertxCtx.removeLocal((Object)ACTIVE_CONTEXT);
            }
            return () -> vertxCtx.putLocal((Object)ACTIVE_CONTEXT, (Object)current);
        }

        public Context current() {
            io.vertx.core.Context vertxCtx = Vertx.currentContext();
            if (vertxCtx == null) {
                return null;
            }
            return (Context)vertxCtx.getLocal((Object)ACTIVE_CONTEXT);
        }
    }
}

