/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.tracing.opentelemetry.HeadersPropagatorGetter;
import io.vertx.tracing.opentelemetry.HeadersPropagatorSetter;
import io.vertx.tracing.opentelemetry.VertxContextStorageProvider;
import java.util.Map;
import java.util.function.BiConsumer;

class OpenTelemetryTracer
implements VertxTracer<Span, Span> {
    private static final TextMapGetter<Iterable<Map.Entry<String, String>>> getter = new HeadersPropagatorGetter();
    private static final TextMapSetter<BiConsumer<String, String>> setter = new HeadersPropagatorSetter();
    private final Tracer tracer;
    private final ContextPropagators propagators;

    OpenTelemetryTracer(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer("io.vertx");
        this.propagators = openTelemetry.getPropagators();
    }

    public <R> Span receiveRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy)) {
            return null;
        }
        Context tracingContext = this.propagators.getTextMapPropagator().extract(Context.current(), headers, getter);
        if (Span.fromContextOrNull((Context)tracingContext) == null && TracingPolicy.PROPAGATE.equals((Object)policy)) {
            return null;
        }
        Span span = this.reportTagsAndStart(this.tracer.spanBuilder(operation).setParent(tracingContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.SERVER : SpanKind.CONSUMER), request, tagExtractor);
        VertxContextStorageProvider.VertxContextStorage.INSTANCE.attach(context, tracingContext.with((ImplicitContextKeyed)span));
        return span;
    }

    public <R> void sendResponse(io.vertx.core.Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            context.remove((Object)VertxContextStorageProvider.ACTIVE_CONTEXT);
            OpenTelemetryTracer.end(span, response, tagExtractor, failure);
        }
    }

    private static <R> void end(Span span, R response, TagExtractor<R> tagExtractor, Throwable failure) {
        if (failure != null) {
            span.recordException(failure);
        }
        if (response != null) {
            tagExtractor.extractTo(response, (arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1));
        }
        span.end();
    }

    public <R> Span sendRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy) || request == null) {
            return null;
        }
        Context tracingContext = (Context)context.getLocal((Object)VertxContextStorageProvider.ACTIVE_CONTEXT);
        if (tracingContext == null && !TracingPolicy.ALWAYS.equals((Object)policy)) {
            return null;
        }
        if (tracingContext == null) {
            tracingContext = Context.root();
        }
        Span span = this.reportTagsAndStart(this.tracer.spanBuilder(operation).setParent(tracingContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.CLIENT : SpanKind.PRODUCER), request, tagExtractor);
        tracingContext = tracingContext.with((ImplicitContextKeyed)span);
        this.propagators.getTextMapPropagator().inject(tracingContext, headers, setter);
        return span;
    }

    public <R> void receiveResponse(io.vertx.core.Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            OpenTelemetryTracer.end(span, response, tagExtractor, failure);
        }
    }

    private <T> Span reportTagsAndStart(SpanBuilder span, T obj, TagExtractor<T> tagExtractor) {
        int len = tagExtractor.len(obj);
        for (int idx = 0; idx < len; ++idx) {
            span.setAttribute(tagExtractor.name(obj, idx), tagExtractor.value(obj, idx));
        }
        return span.startSpan();
    }
}

