/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.ContextStorageProvider;
import io.opentelemetry.context.Scope;
import io.vertx.core.impl.ContextInternal;

public class VertxContextStorageProvider
implements ContextStorageProvider {
    private static final Object ACTIVE_CONTEXT = new Object();

    public ContextStorage get() {
        return VertxContextStorage.INSTANCE;
    }

    static enum VertxContextStorage implements ContextStorage
    {
        INSTANCE;


        public Scope attach(Context toAttach) {
            ContextInternal current = ContextInternal.current();
            if (current == null) {
                return ContextStorage.defaultStorage().attach(toAttach);
            }
            return this.attach((io.vertx.core.Context)current, toAttach);
        }

        public Scope attach(io.vertx.core.Context vertxCtx, Context toAttach) {
            Context current = (Context)vertxCtx.getLocal(ACTIVE_CONTEXT);
            if (current == toAttach) {
                return Scope.noop();
            }
            vertxCtx.putLocal(ACTIVE_CONTEXT, (Object)toAttach);
            if (current == null) {
                return () -> vertxCtx.removeLocal(ACTIVE_CONTEXT);
            }
            return () -> vertxCtx.putLocal(ACTIVE_CONTEXT, (Object)current);
        }

        public Context current() {
            ContextInternal vertxCtx = ContextInternal.current();
            if (vertxCtx == null) {
                return ContextStorage.defaultStorage().current();
            }
            return (Context)vertxCtx.getLocal(ACTIVE_CONTEXT);
        }
    }
}

