/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentracing;

import io.jaegertracing.Configuration;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import io.vertx.core.Context;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public class OpenTracingTracer
implements VertxTracer<Span, Span> {
    private final boolean closeTracer;
    private final Tracer tracer;

    static Tracer createDefaultTracer() {
        Configuration config = Configuration.fromEnv();
        return config.getTracerBuilder().build();
    }

    public OpenTracingTracer(boolean closeTracer, Tracer tracer) {
        this.closeTracer = closeTracer;
        this.tracer = tracer;
    }

    public <R> Span receiveRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, final Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        SpanContext sc;
        if (policy != TracingPolicy.IGNORE && ((sc = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMap(){

            public Iterator<Map.Entry<String, String>> iterator() {
                return headers.iterator();
            }

            public void put(String key, String value) {
                throw new UnsupportedOperationException();
            }
        })) != null || policy == TracingPolicy.ALWAYS)) {
            Span span = this.tracer.buildSpan(operation).ignoreActiveSpan().asChildOf(sc).withTag(Tags.SPAN_KIND.getKey(), kind == SpanKind.RPC ? "server" : "consumer").withTag(Tags.COMPONENT.getKey(), "vertx").start();
            this.reportTags(span, request, tagExtractor);
            context.putLocal((Object)"vertx.tracing.opentracing.span", (Object)span);
            return span;
        }
        return null;
    }

    public <R> void sendResponse(Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            context.removeLocal((Object)"vertx.tracing.opentracing.span");
            if (failure != null) {
                this.reportFailure(span, failure);
            }
            this.reportTags(span, response, tagExtractor);
            span.finish();
        }
    }

    public <R> Span sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, final BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (policy == TracingPolicy.IGNORE) {
            return null;
        }
        Span active = (Span)context.getLocal((Object)"vertx.tracing.opentracing.span");
        if (active != null || policy == TracingPolicy.ALWAYS) {
            Span span = this.tracer.buildSpan(operation).asChildOf(active).withTag(Tags.SPAN_KIND.getKey(), kind == SpanKind.RPC ? "client" : "producer").withTag(Tags.COMPONENT.getKey(), "vertx").start();
            this.reportTags(span, request, tagExtractor);
            if (headers != null) {
                this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMap(){

                    public Iterator<Map.Entry<String, String>> iterator() {
                        throw new UnsupportedOperationException();
                    }

                    public void put(String key, String value) {
                        headers.accept(key, value);
                    }
                });
            }
            return span;
        }
        return null;
    }

    public <R> void receiveResponse(Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            if (failure != null) {
                this.reportFailure(span, failure);
            }
            this.reportTags(span, response, tagExtractor);
            span.finish();
        }
    }

    private <T> void reportTags(Span span, T obj, TagExtractor<T> tagExtractor) {
        int len = tagExtractor.len(obj);
        for (int idx = 0; idx < len; ++idx) {
            span.setTag(tagExtractor.name(obj, idx), tagExtractor.value(obj, idx));
        }
    }

    private void reportFailure(Span span, Throwable failure) {
        if (failure != null) {
            span.setTag("error", true);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("event", "error");
            fields.put("message", failure.getMessage());
            fields.put("error.kind", "Exception");
            fields.put("error.object", failure);
            span.log(fields);
        }
    }

    public void close() {
        if (this.closeTracer && this.tracer != null) {
            this.tracer.close();
        }
    }
}

