/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentracing;

import io.opentracing.Tracer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.tracing.opentracing.OpenTracingOptions;
import io.vertx.tracing.opentracing.OpenTracingTracer;

public class OpenTracingTracerFactory
implements VertxTracerFactory {
    static final OpenTracingTracerFactory INSTANCE = new OpenTracingTracerFactory();
    private final Tracer tracer;

    public OpenTracingTracerFactory() {
        this(null);
    }

    public OpenTracingTracerFactory(Tracer tracer) {
        this.tracer = tracer;
    }

    public VertxTracer tracer(TracingOptions options) {
        if (this.tracer != null) {
            return new OpenTracingTracer(false, this.tracer);
        }
        OpenTracingOptions openTracingOptions = options instanceof OpenTracingOptions ? (OpenTracingOptions)options : new OpenTracingOptions(options.toJson());
        return openTracingOptions.buildTracer();
    }

    public OpenTracingOptions newOptions() {
        return new OpenTracingOptions();
    }

    public OpenTracingOptions newOptions(JsonObject jsonObject) {
        return new OpenTracingOptions(jsonObject);
    }
}

