/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.oracleclient.impl.FailureUtil;
import io.vertx.sqlclient.Tuple;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import oracle.sql.TIMESTAMPTZ;

public class Helper {
    public static void closeQuietly(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> T getOrHandleSQLException(ThrowingSupplier<T> supplier) throws VertxException {
        try {
            return supplier.getOrThrow();
        }
        catch (SQLException sqlException) {
            throw new VertxException((Throwable)sqlException);
        }
    }

    public static void runOrHandleSQLException(ThrowingRunnable runnable) throws VertxException {
        try {
            runnable.runOrThrow();
        }
        catch (SQLException sqlException) {
            throw new VertxException((Throwable)sqlException);
        }
    }

    public static <T> Future<T> first(Flow.Publisher<T> publisher, final ContextInternal context) {
        PromiseInternal promise = context.promise();
        publisher.subscribe(new Flow.Subscriber<T>((Promise)promise){
            volatile Flow.Subscription subscription;
            final /* synthetic */ Promise val$promise;
            {
                this.val$promise = promise;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(T item) {
                context.runOnContext(x -> this.val$promise.tryComplete(item));
                this.subscription.cancel();
            }

            @Override
            public void onError(Throwable throwable) {
                this.val$promise.fail(FailureUtil.sanitize(throwable));
            }

            @Override
            public void onComplete() {
                this.val$promise.tryComplete(null);
            }
        });
        return promise.future();
    }

    public static <T> Future<List<T>> collect(Flow.Publisher<T> publisher, ContextInternal context) {
        PromiseInternal promise = context.promise();
        publisher.subscribe(new Flow.Subscriber<T>((Promise)promise){
            final List<T> list = new ArrayList();
            final /* synthetic */ Promise val$promise;
            {
                this.val$promise = promise;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T item) {
                this.list.add(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.val$promise.fail(FailureUtil.sanitize(throwable));
            }

            @Override
            public void onComplete() {
                this.val$promise.complete(this.list);
            }
        });
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertSqlValue(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof byte[] || value instanceof Number) {
            return value;
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        if (value instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)value).toZonedDateTime().toOffsetDateTime();
        }
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            try {
                String string = c.getSubString(1L, (int)c.length());
                return string;
            }
            finally {
                try {
                    c.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            try {
                byte[] byArray = b.getBytes(1L, (int)b.length());
                return byArray;
            }
            finally {
                try {
                    b.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array a = (java.sql.Array)value;
            try {
                Object arr = a.getArray();
                if (arr != null) {
                    int len = Array.getLength(arr);
                    Object[] castedArray = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        castedArray[i] = Helper.convertSqlValue(Array.get(arr, i));
                    }
                    Object[] objectArray = castedArray;
                    return objectArray;
                }
            }
            finally {
                a.free();
            }
        }
        if (value instanceof RowId) {
            return ((RowId)value).getBytes();
        }
        if (value instanceof Struct) {
            return Tuple.of((Object)((Struct)value).getAttributes());
        }
        return value.toString();
    }

    static interface JdbcRow {
        public <T> T getObject(int var1, Class<T> var2);

        public JdbcRow copy();
    }

    @FunctionalInterface
    public static interface ThrowingRunnable
    extends Runnable {
        public void runOrThrow() throws SQLException;

        @Override
        default public void run() throws VertxException {
            Helper.runOrHandleSQLException(this);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T>
    extends Supplier<T> {
        public T getOrThrow() throws SQLException;

        @Override
        default public T get() throws VertxException {
            return Helper.getOrHandleSQLException(this);
        }
    }
}

