/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OracleConnection;
import io.vertx.oracleclient.impl.OracleConnectionFactory;
import io.vertx.oracleclient.spi.OracleDriver;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;

public class OracleConnectionImpl
extends SqlConnectionBase<OracleConnectionImpl>
implements OracleConnection {
    public OracleConnectionImpl(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, factory, conn, (Driver)OracleDriver.INSTANCE, tracer, metrics);
    }

    public static Future<OracleConnection> connect(Vertx vertx, OracleConnectOptions options) {
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        OracleConnectionFactory client = new OracleConnectionFactory(ctx.owner(), options);
        ctx.addCloseHook((Closeable)client);
        return client.connect((Context)ctx);
    }
}

