/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.json.JsonObject;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleConnectionUriParser {
    private static final String SCHEME_DESIGNATOR_REGEX = "oracle:thin:";
    private static final String USER_INFO_REGEX = "(?<userinfo>[a-zA-Z0-9\\-._~%!*&&[^/]]+/[a-zA-Z0-9\\-._~%!*&&[^/]]+)?";
    private static final String NET_LOCATION_REGEX = "@(?<netloc>([0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+))";
    private static final String PORT_REGEX = ":(?<port>\\d+)";
    private static final String SID = ":(?<sid>[a-zA-Z0-9\\-._~%!*]+)";
    private static final Pattern SCHEME_DESIGNATOR_PATTERN = Pattern.compile("^oracle:thin:");
    private static final Pattern FULL_URI_PATTERN = Pattern.compile("^oracle:thin:(?<userinfo>[a-zA-Z0-9\\-._~%!*&&[^/]]+/[a-zA-Z0-9\\-._~%!*&&[^/]]+)?@(?<netloc>([0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)):(?<port>\\d+):(?<sid>[a-zA-Z0-9\\-._~%!*]+)$");

    public static JsonObject parse(String connectionUri) {
        return OracleConnectionUriParser.parse(connectionUri, true);
    }

    public static JsonObject parse(String connectionUri, boolean exact) {
        try {
            Matcher matcher = SCHEME_DESIGNATOR_PATTERN.matcher(connectionUri);
            if (matcher.find() || exact) {
                JsonObject configuration = new JsonObject();
                OracleConnectionUriParser.doParse(connectionUri, configuration);
                return configuration;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse invalid connection URI: " + connectionUri, e);
        }
    }

    private static void doParse(String connectionUri, JsonObject configuration) {
        Matcher matcher = FULL_URI_PATTERN.matcher(connectionUri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Wrong syntax of connection URI");
        }
        OracleConnectionUriParser.parseUserAndPassword(matcher.group("userinfo"), configuration);
        OracleConnectionUriParser.parseNetLocation(matcher.group("netloc"), configuration);
        OracleConnectionUriParser.parsePort(matcher.group("port"), configuration);
        OracleConnectionUriParser.parseSID(matcher.group("sid"), configuration);
    }

    private static void parseUserAndPassword(String userInfo, JsonObject configuration) {
        if (userInfo == null || userInfo.isEmpty()) {
            return;
        }
        String[] split = userInfo.split("/");
        if (split.length != 2) {
            throw new IllegalArgumentException("User and password must be provided or omitted");
        }
        String user = split[0];
        if (user.isEmpty()) {
            throw new IllegalArgumentException("User is missing");
        }
        String password = split[1];
        if (password.isEmpty()) {
            throw new IllegalArgumentException("Password is missing");
        }
        configuration.put("user", (Object)OracleConnectionUriParser.decodeUrl(user));
        configuration.put("password", (Object)OracleConnectionUriParser.decodeUrl(password));
    }

    private static void parseNetLocation(String hostInfo, JsonObject configuration) {
        if (hostInfo == null || hostInfo.isEmpty()) {
            return;
        }
        OracleConnectionUriParser.parseNetLocationValue(OracleConnectionUriParser.decodeUrl(hostInfo), configuration);
    }

    private static void parsePort(String portInfo, JsonObject configuration) {
        int port;
        if (portInfo == null || portInfo.isEmpty()) {
            return;
        }
        try {
            port = Integer.parseInt(OracleConnectionUriParser.decodeUrl(portInfo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The port must be a valid integer");
        }
        if (port > 65535 || port <= 0) {
            throw new IllegalArgumentException("The port can only range in 1-65535");
        }
        configuration.put("port", (Object)port);
    }

    private static void parseSID(String sidInfo, JsonObject configuration) {
        if (sidInfo == null || sidInfo.isEmpty()) {
            return;
        }
        configuration.put("database", (Object)OracleConnectionUriParser.decodeUrl(sidInfo));
    }

    private static void parseNetLocationValue(String hostValue, JsonObject configuration) {
        if (OracleConnectionUriParser.isRegardedAsIpv6Address(hostValue)) {
            configuration.put("host", (Object)hostValue.substring(1, hostValue.length() - 1));
        } else {
            configuration.put("host", (Object)hostValue);
        }
    }

    private static boolean isRegardedAsIpv6Address(String hostAddress) {
        return hostAddress.startsWith("[") && hostAddress.endsWith("]");
    }

    private static String decodeUrl(String url) {
        return URLDecoder.decode(url, StandardCharsets.UTF_8);
    }
}

