/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.Helper;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleDatabaseHelper {
    public static OracleDataSource createDataSource(OracleConnectOptions options) {
        OracleDataSource oracleDataSource = (OracleDataSource)Helper.getOrHandleSQLException(oracle.jdbc.pool.OracleDataSource::new);
        Helper.runOrHandleSQLException(() -> oracleDataSource.setURL(OracleDatabaseHelper.composeJdbcUrl(options)));
        OracleDatabaseHelper.configureStandardOptions(oracleDataSource, options);
        OracleDatabaseHelper.configureExtendedOptions(oracleDataSource, options);
        OracleDatabaseHelper.configureJdbcDefaults(oracleDataSource);
        return oracleDataSource;
    }

    private static String composeJdbcUrl(OracleConnectOptions options) {
        String serviceName = options.getDatabase();
        String host = options.getHost();
        int port = options.getPort();
        boolean isTcps = options.isSsl();
        return String.format("jdbc:oracle:thin:@%s%s%s%s", Boolean.TRUE.equals(isTcps) ? "tcps:" : "", host, port > 0 ? ":" + port : "", serviceName != null ? "/" + serviceName : "");
    }

    private static void configureStandardOptions(OracleDataSource oracleDataSource, OracleConnectOptions options) {
        int connectTimeout;
        String password;
        String user = options.getUser();
        if (user != null) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setUser(user));
        }
        if ((password = options.getPassword()) != null) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setPassword(password.toString()));
        }
        if ((connectTimeout = options.getConnectTimeout()) > 0) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setLoginTimeout(connectTimeout));
        }
    }

    private static void configureExtendedOptions(OracleDataSource oracleDataSource, OracleConnectOptions options) {
        String tnsAdmin = options.getTnsAdmin();
        if (tnsAdmin != null) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty("oracle.net.tns_admin", tnsAdmin));
        }
    }

    private static void configureJdbcDefaults(OracleDataSource oracleDataSource) {
        String enableJdbcSpecCompliance = "oracle.jdbc.J2EE13Compliant";
        Helper.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty(enableJdbcSpecCompliance, "true"));
        Helper.runOrHandleSQLException(() -> {
            String userValue = oracleDataSource.getConnectionProperty("oracle.jdbc.implicitStatementCacheSize");
            if (userValue == null) {
                oracleDataSource.setConnectionProperty("oracle.jdbc.implicitStatementCacheSize", "25");
            }
        });
    }
}

