/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleColumnDesc;
import io.vertx.oracleclient.impl.OracleRow;
import io.vertx.oracleclient.impl.commands.OraclePreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collector;
import oracle.jdbc.OracleResultSet;

public class RowReader<R, A>
implements Flow.Subscriber<Row>,
Function<oracle.jdbc.OracleRow, Row> {
    private final List<String> types;
    private final Flow.Publisher<Row> publisher;
    private final ContextInternal context;
    private final RowDesc description;
    private final QueryResultHandler<R> handler;
    private volatile Flow.Subscription subscription;
    private final Promise<Void> subscriptionPromise;
    private Promise<Void> readPromise;
    private volatile boolean completed;
    private volatile Throwable failed;
    private final Collector<Row, A, R> collector;
    private A accumulator;
    private int count;
    private final AtomicInteger toRead = new AtomicInteger();
    private final AtomicBoolean wip = new AtomicBoolean();

    public RowReader(OracleResultSet ors, Collector<Row, A, R> collector, Promise<Void> subscriptionPromise, QueryResultHandler<R> handler, ContextInternal context) throws SQLException {
        int cols = ors.getMetaData().getColumnCount();
        this.types = new ArrayList<String>(cols);
        for (int i = 1; i <= cols; ++i) {
            this.types.add(ors.getMetaData().getColumnClassName(i));
        }
        this.publisher = ors.publisherOracle((Function)this);
        this.description = OracleColumnDesc.rowDesc(ors.getMetaData());
        this.subscriptionPromise = subscriptionPromise;
        this.handler = handler;
        this.context = context;
        this.collector = collector;
    }

    public static <R> Future<RowReader<R, ?>> create(OracleResultSet ors, Collector<Row, ?, R> collector, ContextInternal context, QueryResultHandler<R> handler) throws SQLException {
        PromiseInternal promise = context.promise();
        RowReader reader = new RowReader(ors, collector, (Promise<Void>)promise, handler, context);
        reader.subscribe();
        return promise.future().map(reader);
    }

    public Future<Void> read(int fetchSize) {
        if (this.subscription == null) {
            return this.context.failedFuture((Throwable)new IllegalStateException("Not subscribed"));
        }
        if (this.completed) {
            return this.context.succeededFuture();
        }
        if (this.failed != null) {
            return this.context.failedFuture(this.failed);
        }
        if (this.wip.compareAndSet(false, true)) {
            this.toRead.set(fetchSize);
            this.accumulator = this.collector.supplier().get();
            this.count = 0;
            this.readPromise = this.context.promise();
            this.subscription.request(fetchSize);
            return this.readPromise.future();
        }
        return this.context.failedFuture((Throwable)new IllegalStateException("Read already in progress"));
    }

    private void subscribe() {
        this.publisher.subscribe(this);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        this.context.runOnContext(x -> this.subscriptionPromise.complete(null));
    }

    @Override
    public void onNext(Row item) {
        this.collector.accumulator().accept(this.accumulator, item);
        ++this.count;
        if (this.toRead.decrementAndGet() == 0 && this.wip.compareAndSet(true, false)) {
            R result = this.collector.finisher().apply(this.accumulator);
            try {
                this.handler.handleResult(this.count, this.count, this.description, result, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.readPromise.complete();
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.wip.compareAndSet(true, false)) {
            this.failed = throwable;
            this.handler.handleResult(0, 0, this.description, null, throwable);
        }
    }

    @Override
    public void onComplete() {
        if (this.wip.compareAndSet(true, false)) {
            this.completed = true;
            this.context.runOnContext(x -> this.readPromise.complete(null));
        }
    }

    @Override
    public Row apply(oracle.jdbc.OracleRow oracleRow) {
        try {
            return RowReader.transform(this.types, this.description, oracleRow);
        }
        catch (SQLException e) {
            throw new VertxException((Throwable)e);
        }
    }

    private static Row transform(List<String> ors, RowDesc desc, oracle.jdbc.OracleRow or) throws SQLException {
        OracleRow row = new OracleRow(desc);
        for (int i = 1; i <= desc.columnNames().size(); ++i) {
            Object res = Helper.convertSqlValue(or.getObject(i, RowReader.getType(ors.get(i - 1))));
            row.addValue(res);
        }
        return row;
    }

    private static Class<?> getType(String cn) {
        try {
            return OraclePreparedQuery.class.getClassLoader().loadClass(cn);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

