/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.stream.Collector;
import oracle.jdbc.OraclePreparedStatement;

public class OraclePreparedBatch<C, R>
extends QueryCommand<C, R> {
    private final ExtendedQueryCommand<R> query;
    private final List<Tuple> listParams;

    public OraclePreparedBatch(ExtendedQueryCommand<R> query, Collector<Row, C, R> collector, List<Tuple> listParams) {
        super(collector);
        this.query = query;
        this.listParams = listParams;
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return null;
    }

    @Override
    protected boolean returnAutoGeneratedKeys(Connection conn, OraclePrepareOptions options) {
        return false;
    }

    @Override
    protected String query() {
        return this.query.sql();
    }

    @Override
    protected void applyStatementOptions(Statement statement) throws SQLException {
        int fetch = this.query.fetch();
        if (fetch > 0) {
            statement.setFetchSize(fetch);
        }
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (Tuple params : this.listParams) {
            for (int i = 0; i < params.size(); ++i) {
                Object value = this.adaptType(conn, params.getValue(i));
                ps.setObject(i + 1, value);
            }
            ps.addBatch();
        }
    }

    @Override
    protected Future<OracleResponse<R>> doExecute(OraclePreparedStatement ps, ContextInternal context, boolean returnAutoGeneratedKeys) {
        Flow.Publisher publisher;
        try {
            publisher = ps.executeBatchAsyncOracle();
        }
        catch (SQLException e) {
            return context.failedFuture((Throwable)e);
        }
        return Helper.collect(publisher, context).map(list -> {
            int[] res = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                res[i] = ((Long)list.get(i)).intValue();
            }
            return res;
        }).compose(returnedBatchResult -> {
            try {
                return context.succeededFuture(this.decode((Statement)ps, (int[])returnedBatchResult, returnAutoGeneratedKeys));
            }
            catch (SQLException e) {
                return context.failedFuture((Throwable)e);
            }
        });
    }
}

