/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Flow;
import java.util.stream.Collector;
import oracle.jdbc.OraclePreparedStatement;

public class OraclePreparedQuery<C, R>
extends QueryCommand<C, R> {
    private final ExtendedQueryCommand<R> query;
    private final Tuple params;

    public OraclePreparedQuery(ExtendedQueryCommand<R> query, Collector<Row, C, R> collector, Tuple params) {
        super(collector);
        this.query = query;
        this.params = params;
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return OraclePrepareOptions.createFrom(this.query.options());
    }

    @Override
    protected String query() {
        return this.query.sql();
    }

    @Override
    protected void applyStatementOptions(Statement statement) throws SQLException {
        int fetch = this.query.fetch();
        if (fetch > 0) {
            statement.setFetchSize(fetch);
        }
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Object value = this.adaptType(conn, this.params.getValue(i));
            ps.setObject(i + 1, value);
        }
    }

    @Override
    protected Future<OracleResponse<R>> doExecute(OraclePreparedStatement ps, ContextInternal context, boolean returnAutoGeneratedKeys) {
        Flow.Publisher publisher;
        try {
            publisher = ps.executeAsyncOracle();
        }
        catch (SQLException e) {
            return context.failedFuture((Throwable)e);
        }
        return Helper.first(publisher, context).compose(returnedResultSet -> {
            try {
                return context.succeededFuture(this.decode((Statement)ps, (boolean)returnedResultSet, returnAutoGeneratedKeys));
            }
            catch (SQLException e) {
                return context.failedFuture((Throwable)e);
            }
        });
    }
}

